package helion.r4;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * Zapewne kady z nas gra w dziecistwie w odmian puzzli , w ktrej
 * na np. dziewiciu polach znajdowao si osiem ponumerowanych elementw
 * w przypadkowej kolejnoci. Zadaniem gracza byo uoenie ich w rosncej
 * kolejnoci od 1 do 8. <P>
 * Aplet <I>Puzzle</I> przyjmuje trzy parametry z kodu HTML:<BR>
 * <B>NPion, NPoziom</B> - ilo pl w pionie i poziomie<BR>
 * <B>PoziomTrudnosci</B> - poziom trudnoci okrelajcy jak bardzo pocztkowe uoenie zostao "przemieszane"<P>
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: Materiay do "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class Puzzle extends Applet
{
  private boolean isStandalone = false;
  int parNPion;
  int parNPoziom;
  int parPoziomTrudnosci;
  GridLayout gridLayout1 = new GridLayout();
  Button[][] przyciski;
  boolean ulozone;

  //Get a parameter value
  public String getParameter(String key, String def)
  {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public Puzzle()
  {
  }
  //Initialize the applet
  public void init()
  {
    try
    {
      parNPion = Integer.parseInt(this.getParameter("NPion", "3"));
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
    try
    {
      parNPoziom = Integer.parseInt(this.getParameter("NPoziom", "4"));
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }

    try
    {
      parPoziomTrudnosci = Integer.parseInt(this.getParameter("PoziomTrudnosci", "10"));
      if (parPoziomTrudnosci<1) parPoziomTrudnosci=1;
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }

    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
    jmInit();

    gridLayout1.setRows(parNPion);
    //gridLayout1.setColumns(parNPoziom);
  }


  /**
   * Metoda inicjujca interfejs gry tworzc tablic przyciskw o podanym przez
   * parametry <code>NPion</code> i <code>NPoziom</code> rozmiarze. Przyciski s
   * przestawiane miejscami tyle razy, ile wynosi warto parametru
   * <code>PoziomTrudnosci</code>.
   */

  private void jmInit()
  {
    //[nr. kol][nr. wiersza] [x][y]
    przyciski=new Button[parNPoziom][parNPion]; //to tylko deklaracja tablicy referencji bez tworzenia obiektow
    //Ctrl+j fora
    for (int j = 0; j < przyciski[0].length; j++) //nr. wiersza
    {
      for (int i = 0; i < przyciski.length; i++) //nr. kolumny
      {
        przyciski[i][j]=new Button();
        przyciski[i][j].setLabel(String.valueOf(parNPoziom*j+i));
        przyciski[i][j].setFont(new java.awt.Font("Serif", 0, 45));
        this.add(przyciski[i][j]);
        przyciski[i][j].addActionListener(
            new ActionListener()
            {
              public void actionPerformed(ActionEvent e)
                 {
                   nacisnietoPrzycisk((Button)e.getSource());
                 }
            });
        /*
        class Puzzle_przyciski_actionAdapter implements ActionListener
        {
          public void actionPerformed(ActionEvent e)
          {
            nacisnietoPrzycisk((Button)e.getSource());
          }
        };
        przyciski[i][j].addActionListener(new Puzzle_przyciski_actionAdapter());
        */
      }
    }
    przyciski[0][0].setLabel(""); //zerowy ma byc pusty
    przyciski[0][0].setVisible(false);

    //mieszanie przyciskow (wybieramy kierunek przesuniecia niewidocznego przycisku)
    int niewidoczny_x=0; int niewidoczny_y=0;
    int[][] kierunki={{0,-1},{1,0},{0,1},{-1,0}}; //N(0),E(1),S(2),W(3) [kierunek][wsp]
    for (int i=0; i<parPoziomTrudnosci; i++)
    {
      int kierunek=(int)Math.round(3*Math.random()); //przypadkowy wybor kierunku z zakresu 0-3

      if (kierunek==0 && niewidoczny_y==0) kierunek=2; //jezeli nie mozna N, to S
      if (kierunek==2 && niewidoczny_y==parNPion-1) kierunek=0; //jezeli nie mozna S, to N
      if (kierunek==1 && niewidoczny_x==parNPoziom-1) kierunek=3; //jezeli nie mozna E, to W
      if (kierunek==3 && niewidoczny_x==0) kierunek=1; //jezeli nie mozna W, to E

      int nowy_niew_x=niewidoczny_x+kierunki[kierunek][0]; //polozenie niewidocznego przycisku po zamianie
      int nowy_niew_y=niewidoczny_y+kierunki[kierunek][1];

      zamianaPrzyciskow(przyciski[niewidoczny_x][niewidoczny_y],przyciski[nowy_niew_x][nowy_niew_y]);

      niewidoczny_x=nowy_niew_x;
      niewidoczny_y=nowy_niew_y;
    }
  }


  /**
   * Wykonuje akcj zwizan z klikniciem przycisku (identyfikuje przycisk
   * nacinity i puste pole, wywouje metod <code>zamianaPrzyciskow</code> i
   * w razie spenienia odpowiednich warunkw koczy gr wywoujc metod
   * <code>napisKoncowy</code>.
   * @param b referencja do nacinitego przycisku przekazywana z nasuchiwaczy
   * @see zamianaPrzyciskow
   * @see napisKoncowy
   */

  void nacisnietoPrzycisk(Button b)
  {
    //b.setBackground(Color.orange);
    int[] nacisniety_wsp={-1,-1};
    int[] niewidoczny_wsp={-1,-1};
    Button niewidoczny=null;

    for (int i = 0; i < przyciski.length; i++) //nr. kolumny
    {
      for (int j = 0; j < przyciski[i].length; j++) //nr. wiersza
      {
        if (przyciski[i][j]==b) {nacisniety_wsp[0]=i; nacisniety_wsp[1]=j;}
        if (przyciski[i][j].getLabel().equals("")) {niewidoczny_wsp[0]=i; niewidoczny_wsp[1]=j; niewidoczny=przyciski[i][j];}
      }
    }
    //showStatus("Niew. "+niewidoczny_wsp[0]+","+niewidoczny_wsp[1]+"   Nacin. "+nacisniety_wsp[0]+","+nacisniety_wsp[1]);

    if (Math.abs(nacisniety_wsp[0]-niewidoczny_wsp[0])+Math.abs(nacisniety_wsp[1]-niewidoczny_wsp[1])==1)
      zamianaPrzyciskow(b,niewidoczny);
      /*
      {
      //zamiana etykiet
      String temp=b.getLabel();
      b.setLabel(niewidoczny.getLabel());
      niewidoczny.setLabel(temp);
      //ustalenie obiektu niewidocznego
      b.setVisible(false);
      niewidoczny.setVisible(true);
      }
      */

      ulozone=true;
      for (int i = 0; i < przyciski.length; i++)
        for (int j = 0; j < przyciski[i].length; j++)
          if (i+j!=0 && !przyciski[i][j].getLabel().equals(String.valueOf(parNPoziom*j+i)))
            {
              ulozone = false;
              break;
            }
      if (ulozone) napisKoncowy("Wygrae!");
  };


  /**
   * Usuwa z apletu wszystkie komponenty (zestaw przyciskw), zmienia kolor ta
   * i umieszcza na nim napis o treci podanej w argumencie.
   * @param tekst tre napisu
   */

  void napisKoncowy(String tekst)
  {
    this.removeAll();

    this.setBackground(SystemColor.window);
    Label napis=new Label(tekst);
    napis.setAlignment(Label.CENTER);
    napis.setFont(new Font("Serif",0,45));
    napis.setBounds(this.getBounds());
    this.add(napis);
    showStatus("Odwie stron w przegldarce, aby rozpocz gr od nowa");
    Toolkit.getDefaultToolkit().beep();
  }

  /**
   * Metoda pomocnicza zamieniajca przyciski etykietami i zmieniajca widoczno. Nie zwraca adnej wartoci.
   * @param pierwszy pierwszy z zamienianych przycikw
   * @param drugi drugi z zamienianych przyciskw
   */

  void zamianaPrzyciskow(Button pierwszy, Button drugi)
  {
    //zamiana etykiet
    String temp=pierwszy.getLabel();
    pierwszy.setLabel(drugi.getLabel());
    drugi.setLabel(temp);
    //ustalenie obiektu niewidocznego
    //pierwszy.setVisible(pierwszy.getLabel()!="");
    //drugi.setVisible(drugi.getLabel()!="");
    pierwszy.setVisible(!pierwszy.isVisible());
    drugi.setVisible(!drugi.isVisible());
  }

  //Component initialization
  private void jbInit() throws Exception
  {
    this.setBackground(SystemColor.control);
    this.setLayout(gridLayout1);
    gridLayout1.setColumns(2);
    gridLayout1.setRows(3);
  }
  //Get Applet information
  public String getAppletInfo()
  {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo()
  {
    String[][] pinfo =
      {
      {"NPion", "int", "Ilo elementw w pionie"},
      {"NPoziom", "int", "Ilo element w poziomie"},
      };
    return pinfo;
  }
}

