package helion.r3;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class ScrollbarsHSB extends Applet {
  private boolean isStandalone = false;
  Scrollbar scrollbar1 = new Scrollbar();
  Scrollbar scrollbar2 = new Scrollbar();
  Scrollbar scrollbar3 = new Scrollbar();
  Panel panel1 = new Panel();
  CheckboxGroup checkboxGroup1 = new CheckboxGroup();
  Checkbox checkbox1 = new Checkbox();
  Checkbox checkbox2 = new Checkbox();
  //Get a parameter value
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public ScrollbarsHSB() {
  }
  //Initialize the applet
  public void init() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  //Component initialization
  private void jbInit() throws Exception {
    this.setLayout(null);
    scrollbar1.setMaximum(255);
    scrollbar1.setOrientation(0);
    scrollbar1.setBounds(new Rectangle(25, 15, 340, 25));
    scrollbar1.addAdjustmentListener(new ScrollbarsHSB_scrollbar1_adjustmentAdapter(this));
    scrollbar2.setMaximum(255);
    scrollbar2.setOrientation(0);
    scrollbar2.setBounds(new Rectangle(25, 53, 340, 25));
    scrollbar2.addAdjustmentListener(new ScrollbarsHSB_scrollbar2_adjustmentAdapter(this));
    scrollbar3.setMaximum(255);
    scrollbar3.setOrientation(0);
    scrollbar3.setBounds(new Rectangle(25, 92, 340, 25));
    scrollbar3.addAdjustmentListener(new ScrollbarsHSB_scrollbar3_adjustmentAdapter(this));
    panel1.setBackground(Color.black);
    panel1.setBounds(new Rectangle(25, 170, 341, 147));
    checkbox1.setBackground(SystemColor.window);
    checkbox1.setCheckboxGroup(checkboxGroup1);
    checkbox1.setLabel("RGB");
    checkbox1.setBounds(new Rectangle(24, 135, 54, 25));
    checkbox1.addItemListener(new ScrollbarsHSB_checkbox1_itemAdapter(this));
    checkbox2.setBackground(SystemColor.window);
    checkbox2.setCheckboxGroup(checkboxGroup1);
    checkbox2.setLabel("HSB");
    checkbox2.setBounds(new Rectangle(82, 135, 54, 25));
    checkbox2.addItemListener(new ScrollbarsHSB_checkbox2_itemAdapter(this));
    checkboxGroup1.setSelectedCheckbox(checkbox1);
    this.setBackground(SystemColor.window);
    this.add(scrollbar1, null);
    this.add(scrollbar2, null);
    this.add(scrollbar3, null);
    this.add(panel1, null);
    this.add(checkbox1, null);
    this.add(checkbox2, null);
  }
  //Get Applet information
  public String getAppletInfo() {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo() {
    return null;
  }

  void scrollbar1_adjustmentValueChanged(AdjustmentEvent e)
   {
    //RGB
   if (checkbox1.getState())
     panel1.setBackground(new Color(scrollbar1.getValue(),
                                    scrollbar2.getValue(),
                                    scrollbar3.getValue()));
   //HSB
   if (checkbox2.getState())
     panel1.setBackground(Color.getHSBColor(
                scrollbar1.getValue()/(float)scrollbar1.getMaximum(),
                scrollbar2.getValue()/(float)scrollbar2.getMaximum(),
                scrollbar3.getValue()/(float)scrollbar3.getMaximum()));

     showStatus((checkbox1.getState()?"RGB: ":"HSB: ")+scrollbar1.getValue()+", "+scrollbar2.getValue()+", "+scrollbar3.getValue());
  }

  void checkbox1_itemStateChanged(ItemEvent e) {
    //RGB
    if(checkbox1.getState())
      {
      scrollbar1.setValue(panel1.getBackground().getRed()) ;
      scrollbar2.setValue(panel1.getBackground().getGreen()) ;
      scrollbar3.setValue(panel1.getBackground().getBlue()) ;
      }
    //HSB
    if(checkbox2.getState())
      {
      Color kolor=panel1.getBackground();
      float[] hsbkolory=Color.RGBtoHSB(kolor.getRed(),
                                       kolor.getGreen(),
                                       kolor.getBlue(),null);
      scrollbar1.setValue((int)(255*hsbkolory[0]));
      scrollbar2.setValue((int)(255*hsbkolory[1])) ;
      scrollbar3.setValue((int)(255*hsbkolory[2])) ;
      }

    showStatus((checkbox1.getState()?"RGB: ":"HSB: ")+scrollbar1.getValue()+", "+scrollbar2.getValue()+", "+scrollbar3.getValue());
  }
}

class ScrollbarsHSB_scrollbar1_adjustmentAdapter implements java.awt.event.AdjustmentListener {
  ScrollbarsHSB adaptee;

  ScrollbarsHSB_scrollbar1_adjustmentAdapter(ScrollbarsHSB adaptee) {
    this.adaptee = adaptee;
  }
  public void adjustmentValueChanged(AdjustmentEvent e) {
    adaptee.scrollbar1_adjustmentValueChanged(e);
  }
}

class ScrollbarsHSB_scrollbar2_adjustmentAdapter implements java.awt.event.AdjustmentListener {
  ScrollbarsHSB adaptee;

  ScrollbarsHSB_scrollbar2_adjustmentAdapter(ScrollbarsHSB adaptee) {
    this.adaptee = adaptee;
  }
  public void adjustmentValueChanged(AdjustmentEvent e) {
    adaptee.scrollbar1_adjustmentValueChanged(e);
  }
}

class ScrollbarsHSB_scrollbar3_adjustmentAdapter implements java.awt.event.AdjustmentListener {
  ScrollbarsHSB adaptee;

  ScrollbarsHSB_scrollbar3_adjustmentAdapter(ScrollbarsHSB adaptee) {
    this.adaptee = adaptee;
  }
  public void adjustmentValueChanged(AdjustmentEvent e) {
    adaptee.scrollbar1_adjustmentValueChanged(e);
  }
}

class ScrollbarsHSB_checkbox1_itemAdapter implements java.awt.event.ItemListener {
  ScrollbarsHSB adaptee;

  ScrollbarsHSB_checkbox1_itemAdapter(ScrollbarsHSB adaptee) {
    this.adaptee = adaptee;
  }
  public void itemStateChanged(ItemEvent e) {
    adaptee.checkbox1_itemStateChanged(e);
  }
}

class ScrollbarsHSB_checkbox2_itemAdapter implements java.awt.event.ItemListener {
  ScrollbarsHSB adaptee;

  ScrollbarsHSB_checkbox2_itemAdapter(ScrollbarsHSB adaptee) {
    this.adaptee = adaptee;
  }
  public void itemStateChanged(ItemEvent e) {
    adaptee.checkbox1_itemStateChanged(e);
  }
}
