package helion.r3;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.io.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class Info extends Applet{
  private boolean isStandalone = false;
  BorderLayout borderLayout1 = new BorderLayout();
  TextArea textArea1 = new TextArea();
  Button button1 = new Button();
  //Get a parameter value
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public Info() {
    }

  //Initialize the applet
  public void init() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }

    //Przygotowywanie i wyswietlanie informacji o systemie
    //textArea1.setText(readSystemInfo());
    String informacje=readSystemInfo();
    textArea1.setText(informacje);
    System.out.println(informacje);
  }

  //Component initialization
  private void jbInit() throws Exception {
    textArea1.setText("textArea1");
    this.setLayout(borderLayout1);
    button1.setLabel("Zamknij");
    button1.addActionListener(new Info_button1_actionAdapter(this));
    this.add(textArea1, BorderLayout.CENTER);
    if (this.isStandalone) this.add(button1, BorderLayout.SOUTH);
  }

  //Get Applet information
  public String getAppletInfo() {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo() {
    return null;
  }
  //Main method
  public static void main(String[] args) {
    System.out.println("Info 1.0  (c) Jacek Matulewski\n");

    //Aplikacja konsolowa
    boolean textonly=false;
    for (int i = 0; i < args.length; i++)
      //if ((args[i].charAt(0)=='-' || args[i].charAt(0)=='/') && args[i].charAt(1)=='t')
      if (args[i].startsWith("-t") || args[i].startsWith("/t"))
        textonly=true;

    Info applet = new Info();
    applet.isStandalone = true;

    if (textonly)
    {
      System.out.println(applet.readSystemInfo());
      return;
    }

    Frame frame;

    class Frame_Close extends Frame
    {
      public Frame_Close()
          {
            enableEvents(AWTEvent.WINDOW_EVENT_MASK);
            //enableEvents(WindowEvent.WINDOW_CLOSING);
          }

      protected void processWindowEvent(WindowEvent e)
          {
            super.processWindowEvent(e);
            if (e.getID() == WindowEvent.WINDOW_CLOSING)
              //System.exit(0);
              this.dispose();
          }
    };

    frame = new Frame_Close();
    frame.setTitle("Applet Frame");
    frame.add(applet, BorderLayout.CENTER);
    applet.init();
    applet.start();
    frame.setSize(640,480);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
    frame.setVisible(true);
  }

  private String readSystemInfo() {
    String wynik="Informacje o Javie:";

    //Informacje podstawowe
    wynik+="\n   wersja Javy: "+System.getProperty("java.version");
    wynik+="\n   dostawca Javy: "+
                    System.getProperty("java.vendor")+" ("+
                    System.getProperty("java.vendor.url")+")";
    wynik+="\n\nInformacje o systemie";
    wynik+="\n   OS: "+System.getProperty("os.name")+
                    ", wersja: "+System.getProperty("os.version");
    wynik+="\n   typ: "+System.getProperty("os.arch");
    if (isStandalone)
         {
         wynik+="\n\nInformacje niedostpne dla apletu:";
         wynik+="\n   JVM: " + System.getProperty("java.vm.name") +
                           ", wersja: " + System.getProperty("java.vm.version");
         wynik+="\n   JRE: " + System.getProperty("java.home");
         wynik+="\n   nazwa uytkownika: " + System.getProperty("user.name");
         wynik+="\n   katalog domowy uytkownika: " + System.getProperty("user.home");
         wynik+="\n   biecy katalog uytkownika: " + System.getProperty("user.dir");
         }

    //Dodatkowe informacje (pamiec)
    Runtime rt=Runtime.getRuntime();
    wynik+="\n\nInformacje o rodowisku dziaania maszyny wirtualnej:";
    long total=rt.totalMemory();
    long free=rt.freeMemory();
    int procenty=Math.round(100*free/(float)total);
    wynik+="\n   Dostpna pami: "+total/1024+" kB";
    wynik+="\n   Wolna pami: "+free/1024+" kB  ("+procenty+"%)";

    //Dodatkowe informacje (czcionki)
    //Wiecej czcionek VJM Microsoftu niz Suna
    //Metoda getFontList jest uznana za przestarzala, ale nowa dopiero w JDK 1.2
    Toolkit tk=Toolkit.getDefaultToolkit();
    String[] czcionki=tk.getFontList();
    //String[] czcionki=GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    wynik+="\n\nLista dostpnych czcionek:";
    for (int i = 0; i < czcionki.length; i++) wynik+="\n   "+czcionki[i];

    Dimension sd=tk.getScreenSize();
    wynik+="\n\nRozdzielczo ekranu: "+sd.width+" x "+sd.height;

    return wynik;
  }

  void button1_actionPerformed(ActionEvent e) {
    System.exit(0);
  }

}

class Info_button1_actionAdapter implements java.awt.event.ActionListener {
  Info adaptee;

  Info_button1_actionAdapter(Info adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.button1_actionPerformed(e);
  }
}
