package helion.r2;

public class Ulamek implements Cloneable
{
  private int licznik, mianownik=1;

  public static final Ulamek zero =new Ulamek(0);
  public static final Ulamek jeden=new Ulamek(1);
  public static final Ulamek polowa=new UlamekNoException(1,2);
  public static final Ulamek cwierc=new UlamekNoException(1,4);
  public static final Ulamek ZERO=zero;
  public static final Ulamek JEDEN=jeden;
  public static final Ulamek POLOWA=polowa;
  public static final Ulamek CWIERC=cwierc;

  public Ulamek(int licznik,int mianownik) throws Exception
  {
    try
    {
      setMianownik(mianownik);
      setLicznik(licznik);
    }
    catch(Exception exc)
    {
      throw exc;
    }
  }

  public Ulamek(int liczba)
  {
    setLicznik(liczba);
    try {setMianownik(1);} catch(Exception exc) {};
    //mianownik=1;
  }

  public Ulamek()
  {
    //setLicznik(0); try {setMianownik(1);} catch(Exception exc) {};
    //licznik=0; mianownik=1;
  }

  public void setLicznik(int licznik) {this.licznik=licznik;};
  public int getLicznik() {return licznik;}
  public void setMianownik(int mianownik) throws Exception
  //public void setMianownik(int mianownik) throws Error
  {
    if (mianownik!=0)
      this.mianownik=mianownik;
      else throw new Exception("Mianownik nie moe by rwny 0");
      //else throw new Error("Mianownik nie moe by rwny 0");
  };
  public int getMianownik() {return mianownik;}

  public boolean equals(Object obj)
  {
    if (!(obj instanceof Ulamek)) return false;
    Ulamek ulamek=(Ulamek)obj;
    //return (this.getLicznik()==ulamek.getLicznik() && this.getMianownik()==ulamek.getMianownik());
    return (this.getLicznik()/(double)ulamek.getLicznik() == this.getMianownik()/(double)ulamek.getMianownik());
  }

  public Object clone() throws CloneNotSupportedException
  {
    try
    {
      return super.clone();
    }
    catch(CloneNotSupportedException exc)
    {
      throw exc;
    }
  }

  public String toString()
  {
    return String.valueOf(licznik)+"/"+String.valueOf(mianownik);
  }

  public double toDouble()
  {
    return licznik/(double)mianownik;
  }

  public static Ulamek odwroc(Ulamek ulamek) throws Exception
  {
    try
    {
      return new Ulamek(ulamek.getMianownik(),ulamek.getLicznik());
    }
    catch(Exception exc)
    {
      throw exc;
    }
  }

  public Ulamek odwroc() throws Exception
  {
    try
    {
      return odwroc(this);
    }
    catch(Exception exc)
    {
      throw exc;
    }
  }

  public static Ulamek dodaj(Ulamek u1,Ulamek u2)
  {
    int a=u1.getLicznik();
    int b=u1.getMianownik();
    int c=u2.getLicznik();
    int d=u2.getMianownik();
    //mozemy miec wewnosc, ze b*d jest rozne od zera
    //wiec stosujemy konstruktor bez wyjatkow
    return new UlamekNoException(a*d+b*c,b*d);
  }

  public Ulamek dodaj(Ulamek u2)
  {
    return dodaj(this,u2);
  }

  public void uprosc()
  {
    //NWD
    int mniejsza=(Math.abs(licznik)<Math.abs(mianownik))
        ?Math.abs(licznik):Math.abs(mianownik);
    for(int i=mniejsza;i>0;i--)
      if ((licznik%i==0) && (mianownik%i==0))
      {
        licznik/=i;
        mianownik/=i;
      }
    //znaki
    if (licznik*mianownik<0)
    {
      licznik=-Math.abs(licznik);
      mianownik=Math.abs(mianownik);
    }
    else
    {
      licznik=Math.abs(licznik);
      mianownik=Math.abs(mianownik);
    }
  }

}

class UlamekNoException extends Ulamek
{
  public UlamekNoException(int licznik,int mianownik)
  {
    super(); //tu to tylko kurtuazja, ale dobrze miec nawyk
    try
    {
      setMianownik(mianownik);
      setLicznik(licznik);
    }
    catch(Exception exc)
    {
      //odpowiedzialnosc za poprawne wlasnosci mianownika spada na uzytkownika
    }
  }
}