unit Rejestr;

interface

uses Forms, Registry, Windows, Dialogs;

function CzytajUstawieniaOkna(okno :TForm;klucz :String; komunikaty: Boolean) :Boolean;
function ZapiszUstawieniaOkna(okno :TForm;klucz :String; komunikaty: Boolean) :Boolean;
procedure ZapiszAutostart(nazwa :String; plikEXE :String);
procedure UsunAutostart(nazwa :String);
function SprawdzAutostart(nazwa :String) :Boolean;

implementation

{ USTAWIENIE OKNA }

function CzytajUstawieniaOkna(okno :TForm; klucz :String; komunikaty: Boolean) :Boolean;
var Rejestr :TRegistry;
begin
Result:=False;
Rejestr:=TRegistry.Create; //tworzenie instancji TRegistry
with Rejestr do
  begin
  Access:=KEY_READ;  //nadawanie uprawnie do odczytu rejestru
  RootKey:=HKEY_CURRENT_USER; //wybr klucza gwnego

  if KeyExists(klucz) then //czy klucz istnieje?
    if OpenKey(klucz,False) then //otwieranie klucza
      begin
	    //zapisywanie danych
      if ValueExists('Left') then okno.Left:=ReadInteger('Left');
      if ValueExists('Top') then okno.Top:=ReadInteger('Top');
      if ValueExists('Width') then okno.Width:=ReadInteger('Width');
      if ValueExists('Height') then okno.Height:=ReadInteger('Height');
      CloseKey; //zamknicie dostpu do klucza rejestru
      Result:=True;
      end
      else
      begin
        if komunikaty then ShowMessage('Klucz "'+klucz+'" nie moe by otwarty.');
      end
    else
    if komunikaty then ShowMessage('Klucz "'+klucz+'" nie istnieje.');
  Free; //usuniecie instancji TRegistry z pamici
  end; //koniec with-Rejestr
end;

function ZapiszUstawieniaOkna(okno :TForm; klucz :String; komunikaty: Boolean) :Boolean;
var Rejestr :TRegistry;
begin
Result:=False;
Rejestr:=TRegistry.Create;
Rejestr.Access:=KEY_WRITE;
Rejestr.RootKey:=HKEY_CURRENT_USER;

if not Rejestr.KeyExists(klucz) then
  if not Rejestr.CreateKey(klucz) then
    begin
    ShowMessage('Klucz "'+klucz+'" nie moe by utworzony.');
    Rejestr.Free;
    Exit;
    end;

if Rejestr.OpenKey(klucz,False) then
  begin
  Rejestr.WriteInteger('Left',okno.Left);
  Rejestr.WriteInteger('Top',okno.Top);
  Rejestr.WriteInteger('Width',okno.Width);
  Rejestr.WriteInteger('Height',okno.Height);
  Rejestr.CloseKey;
  Result:=True;
  end
  else ShowMessage('Klucz "'+klucz+'" nie moe by otwarty.');

Rejestr.Free;
end;

{ AUTOSTART }

procedure ZapiszAutostart(nazwa :String; plikEXE :String);
const klucz :String ='\SOFTWARE\Microsoft\Windows\CurrentVersion\Run';
var Rejestr :TRegistry;
begin
Rejestr:=TRegistry.Create;
Rejestr.Access:=KEY_SET_VALUE;
Rejestr.RootKey:=HKEY_CURRENT_USER;
if Rejestr.OpenKey(klucz,False) then
  begin
  Rejestr.WriteString(nazwa,plikEXE);
  Rejestr.CloseKey;
  end
  else ShowMessage('Klucz "'+klucz+'" nie istnieje lub nie moe by otwarty.');
Rejestr.Free;
end;

procedure UsunAutostart(nazwa :String);
const klucz='\SOFTWARE\Microsoft\Windows\CurrentVersion\Run';
var Rejestr :TRegistry;
begin
Rejestr:=TRegistry.Create;
Rejestr.Access:=KEY_SET_VALUE;
Rejestr.RootKey:=HKEY_CURRENT_USER;
if Rejestr.OpenKey(klucz,False) then
  begin
  Rejestr.DeleteValue(nazwa);
  Rejestr.CloseKey;
  end
  else ShowMessage('Klucz "'+klucz+'" nie istnieje lub nie moe by otwarty.');
Rejestr.Free;
end;

function SprawdzAutostart(nazwa :String) :Boolean;
const klucz='\SOFTWARE\Microsoft\Windows\CurrentVersion\Run';
var Rejestr :TRegistry;
begin
Result:=False;
Rejestr:=TRegistry.Create;
Rejestr.Access:=KEY_QUERY_VALUE;
Rejestr.RootKey:=HKEY_CURRENT_USER;
if Rejestr.OpenKey(klucz,False) then
  begin
  Result:=Rejestr.ValueExists(nazwa);
  Rejestr.CloseKey;
  end
  else ShowMessage('Klucz "'+klucz+'" nie istnieje lub nie moe by otwarty.');
Rejestr.Free;
end;

end.
