unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Printers, Drukowanie;

type
  TForm1 = class(TForm)
    RichEdit1: TRichEdit;
    PrintDialog1: TPrintDialog;
    Button1: TButton;
    ComboBox1: TComboBox;
    Button2: TButton;
    procedure Button2Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
if PrintDialog1.Execute
  then RichEdit1.Print('Drukowanie dokumentu z aplikacji '+Application.Title);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  tekst :TStringList;
  czcionka :TFont;
  strony :Integer;
begin
tekst:=TStringList.Create;
tekst.Add('Czcionki drukarki:');
tekst.AddStrings(Printer.Fonts);
ShowMessage('Ilo linii: '+IntToStr(tekst.Count));

//konfiguracja czcionki wydruku
czcionka:=TFont.Create;
czcionka.Assign(Printer.Canvas.Font);
czcionka.Size:=12;
czcionka.Name:='Times New Roman';
czcionka.Color:=clNavy;
strony:=Drukuj(tekst,czcionka,False);
czcionka.Free;
tekst.Free;
ShowMessage('Wydrukowano '+IntToStr(strony)+' stron');
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
Printer.PrinterIndex:=ComboBox1.ItemIndex;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
ComboBox1.Items:=Printer.Printers;
ComboBox1.ItemIndex:=Printer.PrinterIndex;
end;

end.
