unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, System.ComponentModel, Borland.Vcl.ExtCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure Image1DblClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure ZapiszObrazDoPliku(Sender: TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.FormCreate(Sender: TObject);
var NazwaPliku :String;
begin
if ParamCount>0 then
  begin
  NazwaPliku:=ParamStr(1);
  if FileExists(NazwaPliku) then
    begin
    Image1.Picture.LoadFromFile(NazwaPliku);
    Self.Caption:=NazwaPliku;
    end
    else ShowMessage('Plik '+NazwaPliku+' nie istnieje!');
  end;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
case Key of
  VK_ESCAPE: Close();
  Ord('O'): Image1DblClick(Sender);
  Ord('S'): ZapiszObrazDoPliku(Sender);
end;
end;

procedure TForm1.Image1DblClick(Sender: TObject);
begin
if (OpenDialog1.Execute) then
  begin
  Image1.Picture.LoadFromFile(OpenDialog1.FileName);
  Form1.Caption:=OpenDialog1.FileName;
  end;
end;

procedure TForm1.ZapiszObrazDoPliku(Sender: TObject);
begin
SaveDialog1.DefaultExt:=ExtractFileExt(OpenDialog1.FileName);
SaveDialog1.Filename:=OpenDialog1.FileName;
if (SaveDialog1.Execute) then
  begin
  Image1.Picture.Graphic.SaveToFile(SaveDialog1.FileName);
  Form1.Caption:=SaveDialog1.FileName;
  end;
end;

end.
