unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  TRownanieKwadratowe = class
  strict private
    function Delta :Double;
  public
    a,b,c :Double;
    constructor Create(a,b,c :Double);
    function X1 :Double;
    function X2 :Double;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

constructor TRownanieKwadratowe.Create(a,b,c :Double);
begin
inherited Create;
Self.a:=a;
Self.b:=b;
Self.c:=c;
end;

function TRownanieKwadratowe.Delta :Double;
begin
Result:=b*b-4*a*c;
end;

function TRownanieKwadratowe.X1 :Double;
begin
if Delta<0 then raise Exception.Create('Rwnanie nie ma rozwiza');
Result:=(-b-Sqrt(Delta))/(2*a);
end;

function TRownanieKwadratowe.X2 :Double;
begin
if Delta<0 then raise Exception.Create('Rwnanie nie ma rozwiza');
Result:=(-b+Sqrt(Delta))/(2*a);
end;

procedure TForm1.Button1Click(Sender: TObject);
var rk :TRownanieKwadratowe;
begin
rk:=TRownanieKwadratowe.Create(1,1,-2);
try
  ShowMessage('Rozwizania: x1='+FloatToStr(rk.X1)+', x2='+FloatToStr(rk.X2));
except
  on E: Exception do ShowMessage('Bd: '+E.Message);
end;
rk.Free;
end;

end.
