//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

class TKlasa
{
    private:
        AnsiString stan;
    public:
        TKlasa(AnsiString stan="Domyslny")
            :stan(stan)
        {
            ShowMessage("TKlasa::TKlasa, stan="+stan);
        }
        TKlasa(const TKlasa& Oryginal)
        {
            stan=Oryginal.stan;
            ShowMessage("TKlasa::TKlasa, konstruktor copy, stan="+stan);
        }
        ~TKlasa(){ShowMessage("TKlasa::~TKlasa, stan="+stan);}
        void UstawStan(AnsiString stan)
        {
            ShowMessage("TKlasa::UstawStan, stary stan="+this->stan+", nowy stan="+stan);
            this->stan=stan;
        }
        void PokazStan(){ShowMessage("TKlasa::PokazStan, stan="+stan);}
};

//---------------------------------------------------------------------------

void __fastcall TForm1::Button0Click(TObject *Sender)
{
    TKlasa domyslny;
    TKlasa a("a");
    TKlasa b(a);
    TKlasa c=a;

    TKlasa* d=new TKlasa("dynamicznie");
    TKlasa* e=d;
    delete d;
}

//---------------------------------------------------------------------------

template<typename T> class InteligentnyWskaznik
{
    private:
        T* wskaznik; //opakowywany wskaznik
        T* get() //ze sprawdzaniem, czy nie mamy wskaznika pustego
        {
            if(wskaznik==NULL) throw Exception("Pusty wskanik!");
            return wskaznik;
        };
    public:
        explicit InteligentnyWskaznik(T* wskaznik):wskaznik(wskaznik){ShowMessage("InteligentnyWskaznik::InteligentnyWskaznik");} //explicit nie pozwala na niejawne konwersje argumentow konstruktora
        //~InteligentnyWskaznik(){delete wskaznik;wskaznik=NULL;ShowMessage("InteligentnyWskaznik::~InteligentnyWskaznik");} //czas zycia jak na stosie
        ~InteligentnyWskaznik()
        {
            if (wskaznik==NULL)
            {
                ShowMessage("InteligentnyWskaznik::~InteligentnyWskaznik, wskaznik jest rowny NULL");

            }
            else
            {
                ShowMessage("InteligentnyWskaznik::~InteligentnyWskaznik, usuwam obiekt");
                delete wskaznik; //czas zycia jak na stosie
                wskaznik=NULL; //o to zwykle sie niestety nie dba
            }
        }
        T* operator ->() {return get();}
        T& operator *() {return *get();}

        /*
        //konstruktor copy
        InteligentnyWskaznik(const InteligentnyWskaznik& Oryginal)
        {
            ShowMessage("InteligentnyWskaznik::InteligentnyWskaznik, konstruktor copy");
            wskaznik=new T(*Oryginal.operator->()); //tworzy nowy obiekt, a nie tylko przepisuje wskaznik
        }
        */
};

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    try
    {
        InteligentnyWskaznik<TKlasa> wsk(new TKlasa("A"));
        wsk->UstawStan("B");
        (*wsk).PokazStan();
    }
    catch(Exception& exc)
    {
        ShowMessage("Wyjtek: "+exc.Message);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
    try
    {
        TKlasa* pustyWskaznik=NULL;
        InteligentnyWskaznik<TKlasa> wsk(pustyWskaznik);
        wsk->UstawStan("B");
        (*wsk).PokazStan();
    }
    catch(Exception& exc)
    {
        ShowMessage("Wyjtek: "+exc.Message);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
    InteligentnyWskaznik<double> wsk(new double(1.0));
    *wsk=2.0;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button4Click(TObject *Sender)
{
    //Sprawdzic dzialanie ze zdefiniowanym konstruktorem copy i bez niego
    InteligentnyWskaznik<TKlasa> wsk(new TKlasa("A"));
    InteligentnyWskaznik<TKlasa> kopia_wsk(wsk);
    wsk->UstawStan("A-oryginal");
    kopia_wsk->UstawStan("A-kopia");
    (*wsk).PokazStan();
    (*kopia_wsk).PokazStan();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)
{
    try
    {
        InteligentnyWskaznik<TButton> wsk(new TButton(this));
        wsk->Parent=this;
        wsk->Width=100;
        (*wsk).Caption="Wskaznik z IQ";
    }
    catch(Exception& exc)
    {
        ShowMessage("Wyjtek: "+exc.Message);
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{
    try
    {
        TButton* pustyWskaznik=new TButton(this);
        delete pustyWskaznik; //!!! samo delete nie czysci wskaznika -> Inteligentny wskaznik nie zadziala
        pustyWskaznik=NULL;
        InteligentnyWskaznik<TButton> wsk(pustyWskaznik);
        wsk->Parent=this;
        wsk->Width=100;
        (*wsk).Caption="Wskaznik z IQ";
    }
    catch(Exception& exc)
    {
        ShowMessage("Wyjtek: "+exc.Message);
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button7Click(TObject *Sender)
{
    InteligentnyWskaznik<TKlasa> wsk(new TKlasa("A"));
    delete &wsk; //tu wskaznik jest czyszczony, ale operator wymaga adresu inteligentnego wskaznika (tu widac, ze inteligentny wsk. nie jest prawdziwym wskaznikiem)
    InteligentnyWskaznik<TKlasa> kopia_wsk(wsk);
    wsk->UstawStan("A-oryginal");
    kopia_wsk->UstawStan("A-kopia");
    (*wsk).PokazStan();
    (*kopia_wsk).PokazStan();
}
//---------------------------------------------------------------------------


