//CZASEM, ABY SKOMPILOWAC TRZEBA UZYC Build

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop


#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

/** 0 **/
//programowanie generyczne lepsze od pisania makr (meta-programowania), bo zachowuje kontrole typow
#include <vector.h>

/** 2 **/
//szablon funkcji
template<typename T> void Drukuj(int ile,vector<T> v)
{
    AnsiString s="vector: ";
    for(int i=0;i<ile;i++) s+=(AnsiString)v[i]+"  ";
    ShowMessage(s);
}

/** 4 **/
//Przeciazanie szablonow funkcji
template<typename T> void Drukuj(vector<T> v)
{
    AnsiString s="vector: ";
    typedef unsigned int uint;
    for(uint i=0;i<v.size();i++) s+=(AnsiString)v[i]+"  ";
    ShowMessage(s);
}

/** 5 **/
//jeszcze jeden przyklad funkcji
template<typename T> void PushFibonacci(vector<T>& v)
{
    v.push_back(v.back()+v[v.size()-2]);
}

/** 1 **/
//uzycie szablonu vector z biblioteki STL
void __fastcall TForm1::Button1Click(TObject *Sender)
{
    typedef int typ;
    //typedef float typ;

    int rozmiar=5; //nie musi byc const
    vector<typ> v(rozmiar);            //konkretyzacja szablonu (czasownik, ang. instantation) = proces zastepowania parametru konkretnym typem, specjalizacja (rzeczownik) = ukonkretniony typ
    for(int i=0;i<rozmiar;i++) v[i]=(typ)(i/2.0);
    Drukuj<typ>(rozmiar,v);
    Drukuj(rozmiar,v); //dedukcja parametru

    /** 3 **/
    //Uzycie metod skladowych
    typ element=(typ)1;
    v.push_back(element); //dodawanie elementow na koncu wektora
    v.push_back(0);
    v.push_back(0);
    v.erase(v.begin()+1); //usuniecie drugiego (arytm. wskaznikow), v.begin - iterator do pierwszego, v.end - do ostatniego, iterator=uogulniony wskaznik
    v.pop_back(); //usuniecie ostatniego elementu
    Drukuj(v.size(),v); //v.size

    /** 4 **/
    Drukuj(v); //v.size

    /** 5 **/
    v.clear();
    v.push_back(0);
    v.push_back(1);
    for(int i=0;i<30;i++) PushFibonacci<typ>(v);
    Drukuj<typ>(v);
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

/** 1 **/
//implementacja zwiazana z pole 1 jest zamknieta w TKlasa1
template<typename T> class TKlasa1
{
    private:
        T pole1;
    public:
        TKlasa1():pole1(T()){} //T() zwraca wartosc domyslna dla danego typu
        TKlasa1(T pole1):pole1(pole1){}
        AnsiString ToString(){return (AnsiString)""+pole1;};

    /** 3 **/
    //szablony metod
    public:
        T GetPole1() const {return pole1;}
        void SetPole1(T pole1){this->pole1=pole1;}
};

/** 2 **/
//implementujemy tylko rzeczy zwiazane z pole2
template<typename T,typename S> class TKlasa2 : public TKlasa1<T>
{
    private:
        S pole2;
    public:
        TKlasa2():TKlasa1<T>(),pole2(S()){}
        TKlasa2(T pole1,S pole2):TKlasa1<T>(pole1),pole2(pole2){}
        AnsiString ToString(){return (AnsiString)"("+TKlasa1<T>::ToString()+", "+pole2+")";};

    /** 3 **/
    //szablony metod
    public:
        S GetPole2() const {return pole2;}
        void SetPole2(S pole2){this->pole2=pole2;}
};


/** 4 **/
//operator dodawanie (typy nie sa mieszane)
template<typename T,typename S> TKlasa2<T,S> operator +(const TKlasa2<T,S>& skladnikA,const TKlasa2<T,S>& skladnikB)
    {
    return TKlasa2<T,S>(skladnikA.GetPole1()+skladnikB.GetPole1(),skladnikA.GetPole2()+skladnikB.GetPole2());
    };


void __fastcall TForm1::Button2Click(TObject *Sender)
{
    /** 1 **/
    TKlasa1<int> obiekt1a;
    ShowMessage("1a: "+obiekt1a.ToString());
    TKlasa1<int> obiekt1b(1);
    ShowMessage("1b: "+obiekt1b.ToString());
    TKlasa1<int>* pobiekt1c=new TKlasa1<int>(2);
    ShowMessage("1c: "+pobiekt1c->ToString());
    delete pobiekt1c;

    /** 2 **/
    TKlasa2<int,float> obiekt2a;
    ShowMessage("2a: "+obiekt2a.ToString());
    TKlasa2<int,float> obiekt2b(1,2.0);
    ShowMessage("2b: "+obiekt2b.ToString());
    TKlasa2<int,float>* pobiekt2c=new TKlasa2<int,float>(3,4.0);
    ShowMessage("2b: "+pobiekt2c->ToString());
    delete pobiekt2c;

    /** 3 **/
    obiekt2a.SetPole1(5);
    obiekt2a.SetPole2(6);
    ShowMessage("2aSet: "+obiekt2a.ToString());

    /** 4 **/
    TKlasa2<int,float> wynik=obiekt2a+obiekt2b;
    ShowMessage("2a+2b: "+wynik.ToString());
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{
    /** 5 **/
    //uzycie do typu innego niz arytmetyczny (musi miec operator +)
    TKlasa2<int,AnsiString> a(1,"Malleus");
    ShowMessage("a: "+a.ToString());
    TKlasa2<int,AnsiString> b(2,"Maleficarum");
    ShowMessage("b: "+b.ToString());
    ShowMessage("a+b: "+(a+b).ToString());
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

/** 6 **/
//wartosc domyslna parametrow szablonu
template<typename T,typename S=int> class TKlasa3 : public TKlasa2<T,S>
{
    public:
        TKlasa3(T pole1,S pole2):TKlasa2<T,S>(pole1,pole2){ShowMessage("Klasa z parametrem domyslnym");}
};

/** 7 **/
//czesciowa specjalizacja szablonu
template<typename S> class TKlasa3<float,S> : public TKlasa2<float,S>
{
    public:
        TKlasa3(float pole1,S pole2):TKlasa2<float,S>(pole1,pole2){ShowMessage("Klasa z czesciowa specjalizacja utworzona przez programiste");}
};

//calkowita specjalizacja szablonu
template<> class TKlasa3<float,int> : public TKlasa2<float,int>
{
    public:
        TKlasa3(float pole1,int pole2):TKlasa2<float,int>(pole1,pole2){ShowMessage("Klasa z calkowita specjalizacja utworzona przez programiste");}
};

void __fastcall TForm1::Button4Click(TObject *Sender)
{
    /** 6 **/
    TKlasa3<int> a(1,2); //dla <float>=<float,int> uzyta zostalaby specjalizacja czesciowa
    ShowMessage("a: "+a.ToString());

    /** 7 **/
    TKlasa3<float,AnsiString> b(1.0f,"Yotz!");
    ShowMessage("b: "+b.ToString());

    TKlasa3<float,int> c(1.0f,2);
    ShowMessage("c: "+c.ToString());
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

/** 8 **/
//parametry niebedace typami
template<typename T,int STALA> class TNowaKlasa
{
    private:
        T tablica[STALA];
    public:
        TNowaKlasa(T wartosc)
        {
            for(int i=0;i<STALA;i++) tablica[i]=wartosc;
            ShowMessage("STALA="+IntToStr(STALA));
        };
        TNowaKlasa(T tablica[STALA]):tablica(tablica){};
        AnsiString ToString()
        {
            AnsiString s="";
            for(int i=0;i<STALA;i++) s+=(AnsiString)tablica[i]+" ";
            return s;
        }
};

//czesciowa specjalizacja
template<typename T> class TNowaKlasa<T,0>
{
    private:
        T zmienna;
    public:
        TNowaKlasa(T wartosc):zmienna(wartosc){ShowMessage("Brak tablicy");};
        AnsiString ToString()
        {
            return (AnsiString)zmienna;
        }
};

void __fastcall TForm1::Button5Click(TObject *Sender)
{
    /** 8 **/
    TNowaKlasa<double,10> nk1(0.0);
    ShowMessage((AnsiString)"nk1: "+nk1.ToString());

    TNowaKlasa<double,0> nk2(0.0);
    ShowMessage((AnsiString)"nk2: "+nk2.ToString());
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

//ZADANIA:
//1. napisac dwuargumentowe makro MIN zwracajace mniejszy z dwoch podanych argumentow
#define MIN(x,y) ((x)<(y)?(x):(y))
//2. napisac dwuargumentowa funkcje Min zwracajaca mniejszy z dwoch podanych argumentow
template <class T> inline const T& Min(const T& t1,const T& t2)
{
    return (t1<t2)?t1:t2;
}

void __fastcall TForm1::Button6Click(TObject *Sender)
{
    //makro
    ShowMessage(IntToStr(MIN(5,1)));
    ShowMessage(FloatToStr(MIN(0.5,0.1)));

    //szablon
    ShowMessage(IntToStr(Min<int>(5,1)));
    ShowMessage(FloatToStr(Min<double>(0.5,0.1)));
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//3.
//zanalizowac dokumentacje szablonu klasy complex (Standard C++ Library = std)
//zdefiniowac typ dcomplex - konkretyzacje szablonu complex dla double
//zdefiniowac stala i (jedn. urojona)
#include <complex>

void __fastcall TForm1::Button7Click(TObject *Sender)
{
    typedef std::complex<double> dcomplex;
    const dcomplex ic=dcomplex(0,1);
    const dcomplex uc=exp(ic*M_PI);
    ShowMessage((AnsiString)"complex uc="+real(uc)+"+"+imag(uc)+"i");
}


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

//szablon obliczajacy potege liczby 3

//szablon bazowy = regula rekurencji
template<int N> class Pow3
{
    public:
        enum{result=3*Pow3<N-1>::result};
};

//specjalizacja calkowita = przerwanie rekurencji (tu rekurencja w dol)
template<> class Pow3<0>
{
    public:
        enum{result=1}; //dla N=0
};

#include <math.h>

void __fastcall TForm1::Button8Click(TObject *Sender)
{
    ShowMessage((AnsiString)"Pow3<7>::result = "+Pow3<7>::result);
    ShowMessage((AnsiString)"pow(3,7) = "+pow(3.0,7));
}
//---------------------------------------------------------------------------


