﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;


namespace Statystyki
{
    public static class Statystyki
    {
        public static double ObliczOdchylenieStandardowe(List<double> lista)
        {
            double srednia = lista.Average();
            double odchylenie = 0;
            foreach (double wartość in lista)
            {
                odchylenie += (wartość - srednia) * (wartość - srednia);
            }
            odchylenie /= lista.Count;
            odchylenie = Math.Sqrt(odchylenie);
            return odchylenie;
        }

        public static double ObliczMedianę(List<double> lista)
        {
            List<double> kopia = new List<double>();
            foreach (double wartość in lista) kopia.Add(wartość);
            kopia.Sort();

            if (kopia.Count % 2 != 0)
                return kopia[kopia.Count / 2];
            else
                return (kopia[kopia.Count / 2 - 1] + kopia[kopia.Count / 2]) / 2.0;
        }
    }
}