﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Statystyki
{
    public partial class Default : System.Web.UI.Page
    {
        //public const string nazwaZmiennej_Suma = "suma";
        double suma = 0;
        List<double> lista = null;

        protected void Page_Load(object sender, EventArgs e)
        {
            //if (Session.Keys.Count == 0) Session.Add(nazwaZmiennej_Suma, 0.0);
            //suma = (double)Session[nazwaZmiennej_Suma];
            suma = (double)Application[Global.nazwaZmiennej_Suma];            
            Label1.Text = suma.ToString();

            lista = (List<double>)Application[Global.nazwaZmiennej_Lista];
            PokażWartości(lista);

            TextBox1.Focus();
        }        

        private void PokażWartości(List<double> lista)
        {            
            if (lista.Count == 0) Label2.Text = "Brak wartości";
            else
            {
                Label2.Text = "";
                foreach (double wartość in lista)
                {
                    Label2.Text += wartość + "<BR>";
                }
            }
        }        

        protected void Button1_Click(object sender, EventArgs e)
        {
            /*
            4. inne parametry: średnia, odchylenie std., mediana
            */

            try
            {                
                double dodawanaWartość = double.Parse(TextBox1.Text);
                suma = (double)Application[Global.nazwaZmiennej_Suma];
                suma += dodawanaWartość;
                Application[Global.nazwaZmiennej_Suma] = suma;

                lista.Add(dodawanaWartość);
                PokażWartości(lista);

                Label1.Text = "Suma: " + suma.ToString();
                Label1.Text += "<BR>Suma: " + lista.Sum();
                Label1.Text += "<BR>Średnia: " + lista.Average();
                Label1.Text += "<BR>Odchylenie standardowe: " + Statystyki.ObliczOdchylenieStandardowe(lista);
                Label1.Text += "<BR>Mediana: " + Statystyki.ObliczMedianę(lista);

                Label1.ForeColor = System.Drawing.Color.Green;      
                //typy wartościowe vs typy referencyjne
            }
            catch (Exception exc)
            {
                Label1.Text = "Błąd: " + exc.Message;
                Label1.ForeColor = System.Drawing.Color.Red;
            }
        }
    }
}