﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace MojaPierwszaAplikacjaAspNet.Properties
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            WyświetlanieWpisów();

            string nazwaUżytkownika = przypomnijNazwęUżytkownika();
            if (nazwaUżytkownika != null) TextBox1.Text = nazwaUżytkownika;
        }

        private const string kolorParzysty = "blue";
        private const string kolorNieparzysty = "navy";

        private static string KolorNagłówka(int numerWpisu)
        {
            return (numerWpisu % 2 == 0) ? kolorParzysty : kolorNieparzysty;
        }

        private string  ŁańcuchWpisu(Models.Wpis wpis, int numerWpisu)
        {
            string nagłówek = "<font color=" + KolorNagłówka(numerWpisu) + "><b> Dodano dnia: " + wpis.Data.ToString() + "</b></font>";
            string treść = wpis.Treść + "<br>";
            string podpis = "<i>" + wpis.NazwaUżytkownika + "</i> (" + wpis.AdresIP + ")<br><hr>";
            return nagłówek + "<br>" + treść + "<br>" + podpis + "<p>";
        }

        private void WyświetlanieWpisów(bool odwróćKolejność = true)
        {
            //List<string> wpisy = (List<string>)Application[Global.nazwaZmiennej_Wpisy];
            Models.Wpisy wpisy = (Models.Wpisy)Application[Global.nazwaZmiennej_Wpisy];

            string treśćWpisów = "";
            /*
            if (!odwróćKolejność) foreach (string wpis in wpisy) treśćWpisów += wpis;                
            else for (int i = wpisy.Count - 1; i >= 0; i--) treśćWpisów += wpisy[i];
            */
            if (!odwróćKolejność) for (int i = 0; i < wpisy.Liczba; ++i) treśćWpisów += ŁańcuchWpisu(wpisy[i], i);
            else for (int i = wpisy.Liczba - 1; i >= 0; i--) treśćWpisów += ŁańcuchWpisu(wpisy[i], i);
            Label1.Text = treśćWpisów;
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            if (TextBox1.Text == "" || TextBox2.Text == "") return; //walidacja po stronie serwera
            //List<string> wpisy = (List<string>)Application[Global.nazwaZmiennej_Wpisy];
            Models.Wpisy wpisy = (Models.Wpisy)Application[Global.nazwaZmiennej_Wpisy];

            Models.Wpis nowyWpis = new Models.Wpis(TextBox1.Text, TextBox2.Text, DateTime.Now, this.Request.UserHostAddress);
            wpisy.Dodaj(nowyWpis);            
            WyświetlanieWpisów();
            TextBox2.Text = "";
            zapamiętajNazwęUżytkownika(TextBox1.Text);
        }

        #region Cookies
        private void zapamiętajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie("nazwaUżytkownika", nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Now.AddDays(7);
            Response.Cookies.Add(ciasteczko);
        }

        private string przypomnijNazwęUżytkownika()
        {
            if (Request.Cookies["nazwaUżytkownika"] != null) return Request.Cookies["nazwaUżytkownika"].Value;
            else return null;
        }
        #endregion
    }
}