﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.IO;

namespace MojaPierwszaAplikacjaAspNet
{
    public static class PlikTekstowy
    {
        private const string nazwaPliku_WpisyTxt = @"d:\wpisy.txt";

        public static void Backup()
        {
            if (File.Exists(nazwaPliku_WpisyTxt)) File.Copy(nazwaPliku_WpisyTxt, nazwaPliku_WpisyTxt + ".bak", true);
        }

        public static bool ZapiszDoPliku(List<string> wpisy)
        {
            try
            {
                Backup();
                File.WriteAllLines(nazwaPliku_WpisyTxt, wpisy.ToArray());
                return true;
            }
            catch (Exception exc)
            {
                Global.Log(exc.Message);
                return false;
            }
        }

        public static bool DopiszDoPliku(string nowyWpis)
        {
            try
            {
                Backup();
                File.AppendAllText(nazwaPliku_WpisyTxt, nowyWpis + "\r\n");
                return true;
            }
            catch (Exception exc)
            {
                Global.Log(exc.Message);
                return false;
            }
        }

        public static List<string> WczytajZPliku()
        {
            try
            {
                return File.ReadAllLines(nazwaPliku_WpisyTxt).ToList();
            }
            catch (Exception exc)
            {
                Global.Log(exc.Message);
                return null;
            }
        }
    }
}