﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Xml.Linq;

namespace KomentarzePodRysunkiem.Models
{
    public class Opinia
    {
        public string Treść;
        public int Ocena;

        public Opinia(string treść, int ocena)
        {
            this.Treść = treść;
            this.Ocena = ocena;
        }
    }

    public static class DAL
    {
        private const string ścieżkaDoPliku = "d:\\Opinie.XML";

        public static void ZapiszDoPlikuXML(List<Opinia> opinie)
        {
            XDocument xml = new XDocument(
                new XElement("Opinie",
                    from opinia in opinie
                    select new XElement("Opinia",
                        new XAttribute("Ocena", opinia.Ocena),
                        opinia.Treść)));
            xml.Save(ścieżkaDoPliku);
        }

        public static List<Opinia> CzytajZPlikuXML()
        {
            List<Opinia> opinie = new List<Opinia>();
            if (System.IO.File.Exists(ścieżkaDoPliku))
            {               
                XDocument xml = XDocument.Load(ścieżkaDoPliku);
                foreach (XElement element in xml.Root.Elements("Opinia"))
                {
                    opinie.Add(
                        new Opinia(
                            element.Value,
                            int.Parse(element.Attribute("Ocena").Value))
                            );
                }                
            }
            return opinie;         
        }
    }
}