﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using System.IO;
using System.Text;

namespace IT_Project_2014
{
    public class Global : System.Web.HttpApplication
    {
        static public string settingsPath;
        static public string listPath;

        protected void Application_Start(object sender, EventArgs e)
        {
            settingsPath = Server.MapPath("Register_Settings.xml"); 
            listPath = Server.MapPath("Register_List.xml"); 
        }

        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {

        }

        static public String LoadVariableFromXml(String variable)
        {
            String atr = "";
            String err_message = "Wartość zmiennej " + variable + " nie została ustawiona w pliku konfiguracyjnym <br />(" + settingsPath + ").";
            String output = "<-- Wartość nie jest poprawnie ustawiona -->";
            bool variable_found = false;

            XmlReader source = XmlReader.Create(settingsPath);

            while (source.Read())
            {
                if (source.NodeType == XmlNodeType.Element)
                {
                    atr = source.Name;
                    source.Read();
                    if (source.NodeType == XmlNodeType.Text)
                    {
                        if (atr == variable)
                        {
                            output = source.Value;
                            variable_found = true;
                        }
                    }
                }
            }
            source.Close();

            if (!variable_found)
            {
                //AddInfo(err_message, 1);
            }

            return output;
        }

        static public void AddXmlContent(XmlDocument doc, XmlElement element, string tag, string value)
        {
            XmlElement newElement = doc.CreateElement(tag);
            XmlText text = doc.CreateTextNode(value);
            element.AppendChild(newElement);
            newElement.AppendChild(text);
            System.Diagnostics.Debug.Write("Dodanie do pliku!\n");
        }

        static public int GetRegisteredCount()
        {
            int count = 0;
            XmlDocument XmlDoc = new XmlDocument();
            XmlDoc.Load(listPath);
            count = XmlDoc.GetElementsByTagName("item").Count;
            return count;
        }

        static public int GetMaxRegisteredCount()
        {
            int x = Convert.ToInt32(Global.LoadVariableFromXml("number"));
            return x;
        }

        static public void AddToRegisteredList(String name, string surname, string email)
        {
            ///Zapisywanie do pliku
            
            XmlDocument XmlDoc = new XmlDocument();
            XmlDoc.Load(listPath);
            
            XmlNode root = XmlDoc.DocumentElement;
            XmlElement parent_elem = XmlDoc.CreateElement("item");
            root.AppendChild(parent_elem);
  
            AddXmlContent(XmlDoc, parent_elem, "id", (Global.GetRegisteredCount()+1).ToString());
            AddXmlContent(XmlDoc, parent_elem, "name", name);
            AddXmlContent(XmlDoc, parent_elem, "surname", surname);
            AddXmlContent(XmlDoc, parent_elem, "email", email);
            System.Diagnostics.Debug.Write("KOMUNIKAT:" + parent_elem.InnerText + "\n");
            // do usunięcie 
            System.Diagnostics.Debug.Write("Dodanie do listy:\n");
            System.Diagnostics.Debug.Write("Id:" + (Global.GetRegisteredCount() + 1).ToString() + "\n");
            System.Diagnostics.Debug.Write("Imię: " + name + "\n");
            System.Diagnostics.Debug.Write("Nazwisko: " + surname + "\n");
            System.Diagnostics.Debug.Write("email:" + email + "\n");
            // ----------------------------------------------------------

            XmlDoc.Save(Global.listPath);
        }

        static public void CleanRegisterList()
        {
            XmlDocument XmlDoc = new XmlDocument();
            XmlDoc.Load(listPath);

            XmlNode node = XmlDoc.DocumentElement;
            System.Diagnostics.Debug.Write("Węzeł do usunięcia: " + node.InnerText + "\n");
            node.RemoveAll();
            XmlDoc.Save(Global.listPath);
            //XmlDoc.DocumentElement.RemoveAll();


            //XmlElement parent_elem = XmlDoc.CreateElement("item");
            //root.AppendChild(parent_elem);
            


            //XmlNode node = XmlDoc.DocumentElement;
            //node.RemoveAll();
        }
    }
}