﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using System.Xml.Xsl;
using System.IO;
using System.Text;

namespace IT_Project_2014
{
    public partial class WebForm1 : System.Web.UI.Page
    {

        protected void Page_Load(object sender, EventArgs e)
        {   
            //Login check
            if (User.Identity.IsAuthenticated == false)
            {
                //Odkomentować:
                Server.Transfer("Adm_login.aspx");
            }

            System.Diagnostics.Debug.Write("Funkcja LOAD\n");
            LoadMiejsca();
            //LoadSettings();
        }

        protected void LoadMiejsca()
        {
            int MiejscaWolne;
            Label_MiejscaZajete.Text = Global.GetRegisteredCount().ToString();
            Label_MiejscaWszystkie.Text = Server.HtmlDecode(Global.LoadVariableFromXml("number"));
            MiejscaWolne = Convert.ToInt32(Server.HtmlDecode(Global.LoadVariableFromXml("number"))) - Convert.ToInt32(Label_MiejscaZajete.Text);
            if (MiejscaWolne == 0)
            {
                Label_MiejscaWolne.Text = "Brak wolnych miejsc. Rejestracja zakończona!";
            }
            else
            {
                Label_MiejscaWolne.Text = MiejscaWolne.ToString();
            }
        }
        /*
        protected override void OnUnload(EventArgs e)
        {
            System.Diagnostics.Debug.Write("Funkcja UNLOAD: " + TextBox1_NazwaWydarzenia.Text + "\n");
            SaveSettings();
        }
        */

        /* do wywalenia
        private void TestXml()
        {
            XmlDocument document = new XmlDocument();
            document.Load(Server.MapPath("Register_Settings.xml"));
            XmlElement newElement;
            newElement = document.CreateElement("settings");
            document.DocumentElement.PrependChild(newElement);
            AddXmlContent(document, newElement, "title", TextBox1_NazwaWydarzenia.Text);
            AddXmlContent(document, newElement, "description", TextBox2_OpisWydarzenia.Text);
            document.Save(Server.MapPath("Register_Settings.xml"));
        }
        */

        //notUsed - do wywalenia
        private void AddXmlContent(XmlDocument doc, XmlElement element, string tag, string value)
        {
            XmlElement newElement = doc.CreateElement(tag);
            XmlText text = doc.CreateTextNode(value);
            element.AppendChild(newElement);
            newElement.AppendChild(text);
        }

        //Dodaje informację dla użytkownika
        // content - treść komunikatu
        // type = typ (0 - zielony, 1 - czerwony)
        private void AddInfo(string content, int type = 0)
        {
            // Dopisywanie komunikatu:
            //Label1_Info.Text = Label1_Info.Text + "<br />" + content;
            // Naspisanie komunikatu:
            Label1_Info.Text = content;

            switch (type)
            {
                case 0:
                    Label1_Info.ForeColor = System.Drawing.Color.Green;
                    break;
                case 1:
                    Label1_Info.ForeColor = System.Drawing.Color.Red;
                    break;
                default:
                    Label1_Info.ForeColor = System.Drawing.Color.Black;
                    break;
            }
        }

        protected void Button1_Zapisz_Click(object sender, EventArgs e)
        {
            SaveSettings();
            /*
            String text;
            XmlDocument settings = new XmlDocument();
            settings.Load(Global.settingsPath);
            XmlNode target = settings.SelectSingleNode("/settings/title");
            //AddInfo("----------------", 0);
            //AddInfo("Element do zmiany: " + target.Name + ", wartość: " + TextBox1_NazwaWydarzenia.Text, 0);
            //target.InnerText = "Nowy tytuł z formularza";
            //AddInfo("Przed zmianą wartości (nazwa wydarzenia): " + target.InnerText, 0);
            target.InnerText = Server.HtmlEncode(TextBox1_NazwaWydarzenia.Text);
            //AddInfo("Zczytany tekst (nazwa wydarzeniaona wartość): " + TextBox1_NazwaWydarzenia.Text, 0);
            //AddInfo("Ustawiona wartość (nazwa wydarzenia): " + target.InnerText, 0);

            target = settings.SelectSingleNode("/settings/description");
            //AddInfo("----------------", 0);
            //AddInfo("Element do zmiany: " + target.Name + ", wartość: " + TextBox2_OpisWydarzenia.Text, 0);
            //AddInfo("Przed zmianą wartości (opis wydarzenia): " + target.InnerText, 0);
            target.InnerText = Server.HtmlEncode(TextBox2_OpisWydarzenia.Text);
            //text = String.Format("{0}", TextBox2_OpisWydarzenia.Text);
            //target.InnerText = Server.HtmlEncode("test1<br />test2");
            //AddInfo("Zczytany tekst (opis wydarzeniaona wartość): " + TextBox2_OpisWydarzenia.Text, 0);
            //AddInfo("Ustawiona wartość (opis wydarzenia): " + target.InnerText, 0);

            //target.InnerText = "Nowy opis z formularza";
            //target.Value = "nowa wartosc";

            settings.Save(Global.settingsPath);
            AddInfo("Dane zostały pomyślnie zapisane.", 0);
            System.Diagnostics.Debug.Write("Funkcja ZAPISZ\n");
            */
        }

        protected void SaveSettings()
        {
            XmlDocument settings = new XmlDocument();
            settings.Load(Global.settingsPath);

            XmlNode target = settings.SelectSingleNode("/settings/title");
            target.InnerText = Server.HtmlEncode(TextBox1_NazwaWydarzenia.Text);
            target = settings.SelectSingleNode("/settings/description");
            target.InnerText = Server.HtmlEncode(TextBox2_OpisWydarzenia.Text);
            target = settings.SelectSingleNode("/settings/number");
            target.InnerText = Server.HtmlEncode(TextBox4_LiczbaUczestnikow.Text);

            settings.Save(Global.settingsPath);
            AddInfo("Dane zostały pomyślnie zapisane.", 0);
            LoadMiejsca();
        }

        protected void Button1_Wczytaj_Click(object sender, EventArgs e)
        {
            //Server.Transfer("Adm_panel.aspx");
            LoadSettings();
            AddInfo("Dane zostały wczytane",0);
        }

        protected void Input_TextChanged(object sender, EventArgs e)
        {
            Button1_Wczytaj.Text = "Przwywróć ustawienia";
        }



        public void LoadSettings()
        {
            TextBox1_NazwaWydarzenia.Text = Server.HtmlDecode(Global.LoadVariableFromXml("title"));
            TextBox2_OpisWydarzenia.Text = Server.HtmlDecode(Global.LoadVariableFromXml("description"));
            TextBox4_LiczbaUczestnikow.Text = Server.HtmlDecode(Global.LoadVariableFromXml("number"));
        }

        protected void Button1_Wyczysc_Click(object sender, EventArgs e)
        {
            Global.CleanRegisterList();
            LoadMiejsca();
        }

    }
}