﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Data.Linq; //Table

namespace KsiegaGosci
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
        }

        protected void Page_Init(object sender, EventArgs e)
        {
            if (TextBox1.Text == "")
            {
                string nazwaUżytkownika = PrzypomnijNazwęUżytkownika();
                if (nazwaUżytkownika != null) TextBox1.Text = nazwaUżytkownika;
                else TextBox1.Text = "Wpisz swoje imię...";
            }
        }

        private int WartośćId(Wpis wpis)
        {
            return wpis.Id;
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            KsiegaGosciDataContext bazaDanych = new KsiegaGosciDataContext();
            Table<Wpis> tabela = bazaDanych.Wpis;

            int największyId = tabela.Max((Func<Wpis,int>)WartośćId);

            Wpis nowyWpis = new Wpis();
            nowyWpis.Id = największyId + 1;
            nowyWpis.NazwaUżytkownika = TextBox1.Text;
            nowyWpis.Treść = TextBox2.Text.Replace("\n", "<BR>");
            nowyWpis.Data = DateTime.Now;
            nowyWpis.AdresIP = Request.UserHostAddress;

            tabela.InsertOnSubmit(nowyWpis);
            bazaDanych.SubmitChanges();

            LinqDataSource1.DataBind();
            Repeater1.DataBind();

            ZapamiętajNazwęUżytkownika(TextBox1.Text);

            Global.DopiszDoRejestruZdarzen("Dodano nowy wpis do bazy danych (Id: " + nowyWpis.Id + ")");
        }

        void ZapamiętajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie("nazwaUżytkownika", nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Now.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }

        string PrzypomnijNazwęUżytkownika()
        {
            HttpCookie ciasteczko = Request.Cookies["nazwaUżytkownika"];
            if (ciasteczko != null) return ciasteczko.Value;
            else return null;
        }

    } //klasa Default
} //namespace KsiegaGosci