﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KsiegaGosci
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (TextBox1.Text == "")
            {
                string nazwaUżytkownika = PrzypomnijNazweUżytkownika();
                if (nazwaUżytkownika != null) TextBox1.Text = nazwaUżytkownika;
            }
        }

        KsiegaGosciDataContext sql = new KsiegaGosciDataContext();

        protected void Button1_Click(object sender, EventArgs e)
        {
            if (TextBox1.Text != "" && TextBox2.Text != "")
            {
                int noweID = 0;
                if (sql.Wpis.Count() > 0) noweID = sql.Wpis.Max(wpis => wpis.ID) + 1;

                Wpis nowyWpis = new Wpis()
                {
                    ID = noweID,
                    NazwaUżytkownika = TextBox1.Text.Trim(),
                    Treść = TextBox2.Text.Trim(),
                    Data = DateTime.Now,
                    AdresIP = Request.UserHostAddress
                };

                sql.Wpis.InsertOnSubmit(nowyWpis);
                sql.SubmitChanges();

                ZapamietajNazweUżytkownika(TextBox1.Text);
            }

            LinqDataSource1.DataBind();
            Repeater1.DataBind();
        }

        void ZapamietajNazweUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie("nazwaUżytkownika", nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Now.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }

        string PrzypomnijNazweUżytkownika()
        {
            HttpCookie ciasteczko=Request.Cookies["nazwaUżytkownika"];
            if (ciasteczko != null) return ciasteczko.Value;
            else return null;
        }
        
    } //klasa
} //przestrzeni nazw