﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;

namespace Wpisy_BibliotekaUslug
{
    //kontrakt danych
    [DataContract]
    public struct Wpis
    {
        [DataMember]
        public string NazwaUżytkownika { get; set; }

        [DataMember]
        public string Treść { get; set; }

        [DataMember]
        public DateTime Data { get; set; }

        [DataMember]
        public string AdresIP { get; set; }

        public Wpis(string nazwaUżytkownika, string treść, DateTime data, string adresIP)
            :this()
        {
            this.NazwaUżytkownika = nazwaUżytkownika;
            this.Treść = treść;
            this.Data = data;
            this.AdresIP = adresIP;
        }
    }

    //kontrakt usługi
    [ServiceContract]
    public interface IUslugaWpisy
    {
        [OperationContract]
        int PobierzIloscWpisow();

        [OperationContract]
        void DodajWpis(Wpis nowyWpis);

        [OperationContract]
        Wpis[] PobierzWszystkieWpisy();
    }
}
