﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace CwiczeniaLINQ
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Button1_Click(null, null);
        }

        class Osoba
        {
            public string Imię;
            public string Nazwisko;
            public int Wiek;
            public string MiastoUrodzenia;
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            List<Osoba> lista = new List<Osoba>();
            lista.Add(new Osoba() { Imię = "Kuba", Nazwisko = "Wszechpolski", Wiek = 39, MiastoUrodzenia = "Toruń" });
            lista.Add(new Osoba() { Imię = "Ania", Nazwisko = "Brzozowska", Wiek = 23, MiastoUrodzenia = "Bydgoszcz" });
            lista.Add(new Osoba() { Imię = "Kamila", Nazwisko = "Duszyńska", Wiek = 23, MiastoUrodzenia = "Toruń" });
            lista.Add(new Osoba() { Imię = "Marta", Nazwisko = "Pakuła", Wiek = 24, MiastoUrodzenia = "Świdnik" });
            lista.Add(new Osoba() { Imię = "Robert", Nazwisko = "Lapeusz", Wiek = 24, MiastoUrodzenia = "Mława" });
            lista.Add(new Osoba() { Imię = "Łukasz", Nazwisko = "Łubkowski", Wiek = 23, MiastoUrodzenia = "Toruń" });
            lista.Add(new Osoba() { Imię = "Adam", Nazwisko = "Jendrzejewski", Wiek = 24, MiastoUrodzenia = "Bydgoszcz" });
            lista.Add(new Osoba() { Imię = "Paulina", Nazwisko = "Lewandowska", Wiek = 23, MiastoUrodzenia = "Bydgoszcz" });

            string s = "<B>Lista studentów:</B><BR>";
            for (int i = 0; i < lista.Count; ++i)
                s += lista[i].Imię + " " + lista[i].Nazwisko + " (" + lista[i].Wiek.ToString() + "), " +
                    lista[i].MiastoUrodzenia + "<BR>";
            Label1.Text = s;

            //LINQ
            var wynikZapytania0 = from Osoba osoba in lista
                                 where osoba.Wiek<30 && osoba.Wiek>23
                                 orderby osoba.Nazwisko
                                 select osoba;

            //zad. 1
            var wynikZapytania1 = from Osoba osoba in lista
                                 where osoba.MiastoUrodzenia == "Toruń"
                                 select osoba.Imię + " " + osoba.Nazwisko;

            var wynikZapytania2 = from Osoba osoba in lista
                                  where osoba.Nazwisko.Length > 8
                                  select osoba.Wiek;

            List<string> wyjatki = new List<string>();
            wyjatki.Add("Kuba");
            wyjatki.Add("Barnaba");
            wyjatki.Add("Bonawentura");

            var wynikZapytania = from Osoba osoba in lista
                                 where osoba.Imię.EndsWith("a") && !wyjatki.Contains(osoba.Imię)
                                 select osoba;

            string s1 = "<B>Wynik zapytania:</B><BR>";
            for (int i = 0; i < wynikZapytania.Count(); ++i)
            {
                Osoba osoba = wynikZapytania.ElementAt(i);
                s1 += osoba.Imię + " " + osoba.Nazwisko +
                    " (" + osoba.Wiek.ToString() + "), " +
                    osoba.MiastoUrodzenia + "<BR>";
            }
            Label2.Text = s1;

            //1. imiona i nazwiska (w jednym łańcuchu) osób, które pochodzą z Torunia
            //2. wiek osób, których nazwiska są dłuższe niż 8 liter
            //3. imiona kobiet
        }
    }
}