﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        string katalogNaPrzeslanePliki = @"C:\PobranePliki";
        katalogNaPrzeslanePliki = System.IO.Path.Combine(katalogNaPrzeslanePliki, DropDownList1.SelectedValue);
        //tu można dodać weryfikację, czy rozszerzenie pasuje do wybranego typu
        
        if (!System.IO.Directory.Exists(katalogNaPrzeslanePliki)) System.IO.Directory.CreateDirectory(katalogNaPrzeslanePliki);

        if (FileUpload1.HasFile)
        {
            //sprawdzanie czy plik graficzny
            string nazwaPliku = FileUpload1.FileName;
            string rozszerzeniePliku = System.IO.Path.GetExtension(nazwaPliku);
            rozszerzeniePliku = rozszerzeniePliku.ToLower();
            if(!( rozszerzeniePliku==".jpg" || rozszerzeniePliku==".jpeg" || rozszerzeniePliku==".jpe" ||
                rozszerzeniePliku==".gif" || rozszerzeniePliku==".bmp"))
            {
                Label1.Text += "<BR><FONT COLOR=magenta>Plik nie ma rozszerzenia wskazującego na plik graficzny (JPEG, GIF, BMP). Plik nie został przesłany.</FONT>";
                return;
            }

            //sprawdzanie czy plik nie jest za duży
            int rozmiarPliku = FileUpload1.PostedFile.ContentLength;
            if (rozmiarPliku > 2100000)
            {
                Label1.Text += "<BR><FONT COLOR=magenta>Plik "+nazwaPliku+" jest zbyt duży (" + rozmiarPliku + " bajtów) .</FONT>";
                return;
            }

            string data = DateTime.Now.ToString().Replace(':','-');
            string opis = TextBox1.Text;
            nazwaPliku = "(" + data + ") [" + opis + "] " + nazwaPliku;
            
            //właściwe uploadowanie pliku
            string ścieżkaPliku=System.IO.Path.Combine(katalogNaPrzeslanePliki,nazwaPliku);
            try
            {
                FileUpload1.SaveAs(ścieżkaPliku);
                Label1.Text += "<BR><FONT COLOR=green>Plik został pomyślnie przesłany i zapisany jako " + ścieżkaPliku + " (rozmiar pliku: "+rozmiarPliku+" bajtów).</FONT>";

                //wyświetlanie ostatnio dodanego obrazu
                string ścieżkaFizycznaKopiiOstatniegoPliku = "ostatni" + System.IO.Path.GetExtension(ścieżkaPliku);
                string urlKopiiOstatniegoPliku = HttpUtility.UrlEncode(ścieżkaFizycznaKopiiOstatniegoPliku);
                string ścieżkaWirtualnaKopiiOstatniegoPliku = "~/" + ścieżkaFizycznaKopiiOstatniegoPliku;
                ścieżkaFizycznaKopiiOstatniegoPliku = Server.MapPath(ścieżkaFizycznaKopiiOstatniegoPliku);                

                //Label1.Text += "<BR>" + ścieżkaFizycznaKopiiOstatniegoPliku;
                //Label1.Text += "<BR>" + ścieżkaWirtualnaKopiiOstatniegoPliku;
                //Label1.Text += "<BR>" + urlKopiiOstatniegoPliku;

                System.IO.File.Copy(ścieżkaPliku, ścieżkaFizycznaKopiiOstatniegoPliku, true);
                Image1.ImageUrl = urlKopiiOstatniegoPliku;
                if (TextBox2.Text != "") Image1.Height = int.Parse(TextBox2.Text);
                if (TextBox3.Text != "") Image1.Width = int.Parse(TextBox3.Text);
                Image1.Visible = true;
            }
            catch(Exception exc)
            {
                Label1.Text += "<BR><FONT COLOR=red>Błąd podczas przesyłania: " + exc.Message + ".</FONT>";
            }
        }
        else
        {
            Label1.Text += "<BR><FONT COLOR=red>Musisz najpierw wybrać plik</FONT>";
        }
    }
}
