﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        string katalogNaPrzeslanePliki = @"C:\PobranePliki";

        if (FileUpload1.HasFile)
        {
            //sprawdzanie czy plik graficzny
            string nazwaPliku = FileUpload1.FileName;
            string rozszerzeniePliku = System.IO.Path.GetExtension(nazwaPliku);
            rozszerzeniePliku = rozszerzeniePliku.ToLower();
            if(!( rozszerzeniePliku==".jpg" || rozszerzeniePliku==".jpeg" || rozszerzeniePliku==".jpe" ||
                rozszerzeniePliku==".gif" || rozszerzeniePliku==".bmp"))
            {
                Label1.Text += "<BR><FONT COLOR=magenta>Plik nie ma rozszerzenia wskazującego na plik graficzny (JPEG, GIF, BMP). Plik nie został przesłany.</FONT>";
                return;
            }

            //sprawdzanie czy plik nie jest za duży
            int rozmiarPliku = FileUpload1.PostedFile.ContentLength;
            if (rozmiarPliku > 2100000)
            {
                Label1.Text += "<BR><FONT COLOR=magenta>Plik "+nazwaPliku+" jest zbyt duży (" + rozmiarPliku + " bajtów) .</FONT>";
                return;
            }

            //właściwe uploadowanie pliku
            string ścieżkaPliku=System.IO.Path.Combine(katalogNaPrzeslanePliki,nazwaPliku);
            try
            {
                FileUpload1.SaveAs(ścieżkaPliku);
                Label1.Text += "<BR><FONT COLOR=green>Plik został pomyślnie przesłany i zapisany jako " + ścieżkaPliku + " (rozmiar pliku: "+rozmiarPliku+" bajtów).</FONT>";
            }
            catch(Exception exc)
            {
                Label1.Text += "<BR><FONT COLOR=red>Błąd podczas przesyłania: " + exc.Message + ".</FONT>";
            }
        }
        else
        {
            Label1.Text += "<BR><FONT COLOR=red>Musisz najpierw wybrać plik</FONT>";
        }
    }
}
