using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using System.Threading.Tasks; //TPL

namespace Stereoscopy
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        GraphicsDevice gd;
        BasicEffect effect;

        BigCube solid;

        bool isRotating = true;

        readonly Vector3 cameraDefaultPosition = new Vector3(1f, 1f, 4.5f);

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }
       
        protected override void Initialize()
        {
            gd = graphics.GraphicsDevice;

            effect = new BasicEffect(gd);
            effect.VertexColorEnabled = false;
            effect.Projection = Matrix.CreatePerspective(2.0f * gd.Viewport.AspectRatio, 2.0f, 1.0f, 100.0f);            
            effect.View = Matrix.CreateLookAt(cameraDefaultPosition, Vector3.Zero, Vector3.Up);

            effect.EnableDefaultLighting();

            base.Initialize();
        }

       
        protected override void LoadContent()
        {
            solid = new BigCube(gd, effect, Content.Load<Texture2D>("CubeTexture"));
            solid.SetXShape();
            spriteBatch = new SpriteBatch(gd);
        }

       
        protected override void UnloadContent()
        {
        }

        KeyboardState previousKeyboardState = Keyboard.GetState();

        protected override void Update(GameTime gameTime)
        {
           
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            //keyboard
            KeyboardState keyboardState = Keyboard.GetState();
            if (keyboardState.IsKeyDown(Keys.Escape)) this.Exit();
            if (keyboardState.IsKeyDown(Keys.Space) && !previousKeyboardState.IsKeyDown(Keys.Space))
            {
                try
                {
                    graphics.ToggleFullScreen();
                }
                catch
                {                    
                }
            }

            float verticalRotation = 0.0f;
            float horizontalRotation = 0.0f;
            if (keyboardState.IsKeyDown(Keys.Up)) verticalRotation = -0.02f;
            if (keyboardState.IsKeyDown(Keys.Down)) verticalRotation = 0.02f;
            if (keyboardState.IsKeyDown(Keys.Right)) horizontalRotation = 0.02f;
            if (keyboardState.IsKeyDown(Keys.Left)) horizontalRotation = -0.02f;
            Quaternion aditionalRotation = Quaternion.CreateFromAxisAngle(new Vector3(1, 0, 0), verticalRotation) *
                                           Quaternion.CreateFromAxisAngle(new Vector3(0, 1, 0), horizontalRotation);

            if (keyboardState.IsKeyDown(Keys.F1)) solid.SetStarShape();
            if (keyboardState.IsKeyDown(Keys.F2)) solid.SetStairsShape();
            if (keyboardState.IsKeyDown(Keys.F3)) solid.SetXShape();
            if (keyboardState.IsKeyDown(Keys.F4)) solid.SetPShape();
            if (keyboardState.IsKeyDown(Keys.F5)) solid.SetOShape();
            if (keyboardState.IsKeyDown(Keys.F6)) solid.SetTShape();
            if (keyboardState.IsKeyDown(Keys.F7)) solid.SetCubeShape();

            if (keyboardState.IsKeyDown(Keys.D0) && !previousKeyboardState.IsKeyDown(Keys.D0)) isRotating = !isRotating;

            previousKeyboardState = keyboardState;

            //rotations    
            Matrix transformation;
            if (!isRotating)
            {
                transformation = Matrix.CreateFromQuaternion(aditionalRotation);
            }
            else
            {
                transformation = Matrix.CreateRotationX(gameTime.ElapsedGameTime.Milliseconds / 1000.0f)
                   * Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);
            }
            if (keyboardState.IsKeyDown(Keys.OemPlus)) transformation *= Matrix.CreateScale(1.01f);
            if (keyboardState.IsKeyDown(Keys.OemMinus)) transformation *= Matrix.CreateScale(0.99f);
            solid.TransformWorld(transformation);

            solid.View = effect.View;
            
            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            gd.Clear(Color.Black);
            solid.Draw();

            base.Draw(gameTime);
        }
    }
}
