float4x4 WVP : WORLDVIEWPROJECTION;

float BiezacaWarstwa;
float DlugoscWlosowFutra;
texture TeksturaFutra;

float MiekkoscWlosow;

sampler probnikFutra = sampler_state
{
	Texture=(TeksturaFutra);
	MinFilter=Point;
	MagFilter=Point;
	MipFilter=Point;
	AddressU=Wrap;
	AddressV=Wrap;
};

texture TeksturaKolorow;

sampler probnikKolorow = sampler_state
{
	Texture=(TeksturaKolorow);
	MinFilter=Point;
	MagFilter=Point;
	MipFilter=Point;
	AddressU=Wrap;
	AddressV=Wrap;
};

struct VSInput
{
	float3 Pozycja : POSITION0;
	float3 Normalna : NORMAL0;
	float2 WspTekstury : TEXCOORD0;
};

struct VSOutput
{
	float4 Pozycja : POSITION0;
	float2 WspTekstury : TEXCOORD0;
};

VSOutput VS(VSInput input)
{
	VSOutput output;
	float3 pozycjaNaWlosie = 
		input.Pozycja+input.Normalna*DlugoscWlosowFutra*BiezacaWarstwa + 
		MiekkoscWlosow*float3(0,-1,0)*(DlugoscWlosowFutra*BiezacaWarstwa)*(DlugoscWlosowFutra*BiezacaWarstwa);
	output.Pozycja = mul(float4(pozycjaNaWlosie,1),WVP);	
	output.WspTekstury=input.WspTekstury;
	return output;
}

float4 PS(VSOutput input) : COLOR0
{
	float4 output_Kolor = tex2D(probnikKolorow,input.WspTekstury);
	output_Kolor.a = tex2D(probnikFutra,input.WspTekstury).a;
	float cieniowanie = lerp(0.4,1,BiezacaWarstwa);
	return output_Kolor;
}

Technique technika
{
	Pass przebieg
	{
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		CullMode = None;

		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}