using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Futro
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        BasicEffect efektCzajniczek, efektDude;
        Model czajniczek, dude, dudeWlosy;

        const int szerokoscTeksturyFutra = 256;
        const int wysokoscTeksturyFutra = 256;
        Effect efektFutra;
        int liczbaWarstw = 40;
        float dlugoscWlosowFutra = 1;
        float gestoscFutra = 0.2f;
        float miekkoscWlosow = 0.6f;
        bool czyWyswietlaneFutro = true;

        bool czyZachowacOryginalneTekstury = false;

        public Game1()
        {
            this.IsMouseVisible = true;

            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            efektCzajniczek = new BasicEffect(this.GraphicsDevice);
            efektCzajniczek.World = Matrix.Identity;
            float wysokoscKamery = 2;
            //wysokoscKamery = 0;
            float odlegloscKamery = 2.5f;
            //odlegloscKamery = 0.8f;
            efektCzajniczek.View = Matrix.CreateLookAt(new Vector3(0, wysokoscKamery, odlegloscKamery), new Vector3(0, wysokoscKamery, 0), Vector3.Up);
            efektCzajniczek.Projection = Matrix.CreatePerspective(
                2f * graphics.GraphicsDevice.Viewport.AspectRatio,
                2f,
                1f,
                100f);

            efektCzajniczek.PreferPerPixelLighting = true;
            efektCzajniczek.EnableDefaultLighting();
            
            efektDude = (BasicEffect)efektCzajniczek.Clone();
            efektDude.World *= Matrix.CreateScale(0.05f);
            efektDude.TextureEnabled = true;

            efektCzajniczek.World *= Matrix.CreateScale(0.2f);
            efektCzajniczek.World *= Matrix.CreateTranslation(0.05f, 3.8f, 0.065f);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            Texture2D teksturaFutra = StworzTekstureFutra(szerokoscTeksturyFutra, wysokoscTeksturyFutra, gestoscFutra);
            Texture2D teksturaKolorowFutra = Content.Load<Texture2D>("tygrys");

            efektFutra = Content.Load<Effect>("EfektFutra");
            efektFutra.Parameters["WVP"].SetValue(efektDude.World * efektDude.View * efektDude.Projection);
            efektFutra.Parameters["TeksturaFutra"].SetValue(teksturaFutra);
            efektFutra.Parameters["DlugoscWlosowFutra"].SetValue(dlugoscWlosowFutra);
            efektFutra.Parameters["TeksturaKolorow"].SetValue(teksturaKolorowFutra); //tygrys (potem nadpisuje oryginalna tekstura)
            efektFutra.Parameters["MiekkoscWlosow"].SetValue(miekkoscWlosow);

            czajniczek = Content.Load<Model>("teapot");
            this.Window.Title = "Ilo siatek czajniczka: " + czajniczek.Meshes.Count.ToString();
            foreach (ModelMesh siatka in czajniczek.Meshes)
            {
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    czescSiatki.Effect = efektCzajniczek;
                }
            }

            dude = Content.Load<Model>("Dude/dude");
            this.Window.Title += ", ilo siatek kolesia: " + dude.Meshes.Count.ToString();
            foreach (ModelMesh siatka in dude.Meshes)
            {
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    BasicEffect efektCzesciSiatki = (BasicEffect)czescSiatki.Effect;
                    efektCzesciSiatki.World = efektDude.World;
                    efektCzesciSiatki.View = efektDude.View;
                    efektCzesciSiatki.Projection = efektDude.Projection;
                    efektCzesciSiatki.EnableDefaultLighting();
                    efektCzesciSiatki.PreferPerPixelLighting = true;
                    //efektCzesciSiatki.Texture = StworzTekstureFutra(256, 256, 0.1f); 
                }
            }
            

            dudeWlosy = Content.Load<Model>("DudeWlosy/dude"); //ten sam model (skopiowany, aby rozne referencje)

            foreach (ModelMesh siatka in dudeWlosy.Meshes)
            {
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    //Texture2D oryginalnaTekstura = czescSiatki.Effect.Parameters["Texture"].GetValueTexture2D();
                    if (czyZachowacOryginalneTekstury)
                    {
                        Texture2D oryginalnaTekstura = (czescSiatki.Effect as BasicEffect).Texture;
                        czescSiatki.Effect = efektFutra;
                        czescSiatki.Effect.Parameters["TeksturaKolorow"].SetValue(oryginalnaTekstura);
                    }
                    else czescSiatki.Effect = efektFutra;
                }
            }
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }


        private Texture2D StworzTekstureFutra(int szerokosc, int wysokosc, float gestosc)
        {
            int liczbaPikseli = szerokosc * wysokosc;

            Color[] kolory = new Color[liczbaPikseli];
            Random r = new Random();
            for (int i = 0; i < liczbaPikseli; ++i)
            {
                kolory[i] = Color.Transparent;
            }

            int liczbaKropek = (int)(gestosc * liczbaPikseli);
            for (int i = 0; i < liczbaKropek; ++i)
            {
                kolory[r.Next(liczbaPikseli)] = Color.Yellow;
            }

            Texture2D teksturaFutra = new Texture2D(
                GraphicsDevice,
                szerokosc,
                wysokosc);
            teksturaFutra.SetData<Color>(kolory);
            return teksturaFutra;
        }

        float poprzedniaDlugoscWlosowFutra = -1;
        float poprzedniaGestoscFutra = -1;
        float poprzedniaMiekkoscWlosow = -1;

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            KeyboardState stanKlawiatury = Keyboard.GetState();
            Matrix macierzObrotu = Matrix.Identity;
            if (stanKlawiatury.IsKeyDown(Keys.Left)) macierzObrotu *= Matrix.CreateRotationY((float)(-2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.Right)) macierzObrotu *= Matrix.CreateRotationY((float)(2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.Up)) macierzObrotu *= Matrix.CreateRotationX((float)(-2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.Down)) macierzObrotu *= Matrix.CreateRotationX((float)(2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.OemComma)) macierzObrotu *= Matrix.CreateRotationZ((float)(2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.OemPeriod)) macierzObrotu *= Matrix.CreateRotationZ((float)(-2 * gameTime.ElapsedGameTime.TotalSeconds));
            efektCzajniczek.World *= macierzObrotu;
            efektDude.World *= macierzObrotu;

            foreach (ModelMesh siatka in dude.Meshes)
            {
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    ((BasicEffect)czescSiatki.Effect).World = efektDude.World;                    
                }
            }

            foreach (ModelMesh siatka in dudeWlosy.Meshes)
            {
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    czescSiatki.Effect.Parameters["WVP"].SetValue(efektDude.World * efektDude.View * efektDude.Projection);
                }
            }

            if (poprzedniaDlugoscWlosowFutra == -1) poprzedniaDlugoscWlosowFutra = dlugoscWlosowFutra;
            if (poprzedniaGestoscFutra == -1) poprzedniaGestoscFutra = gestoscFutra;
            if (poprzedniaMiekkoscWlosow == -1) poprzedniaMiekkoscWlosow = miekkoscWlosow;

            float minimalnaDlugoscWlosowFutra = 0.01f;
            if (stanKlawiatury.IsKeyDown(Keys.Insert))
            {
                if (czyWyswietlaneFutro)
                {
                    if (dlugoscWlosowFutra < minimalnaDlugoscWlosowFutra)
                    {
                        czyWyswietlaneFutro = false;
                        dlugoscWlosowFutra = minimalnaDlugoscWlosowFutra;
                    }
                    else dlugoscWlosowFutra *= 0.9f;
                }
            }
            if (stanKlawiatury.IsKeyDown(Keys.Delete))
            {
                if (!czyWyswietlaneFutro)
                {
                    czyWyswietlaneFutro = true;
                    dlugoscWlosowFutra = minimalnaDlugoscWlosowFutra;
                }
                dlugoscWlosowFutra *= 1.1f;
            }
            if (stanKlawiatury.IsKeyDown(Keys.Home)) gestoscFutra *= 0.9f;
            if (stanKlawiatury.IsKeyDown(Keys.End)) gestoscFutra *= 1.1f;
            if (stanKlawiatury.IsKeyDown(Keys.PageUp)) miekkoscWlosow -= 0.01f;
            if (stanKlawiatury.IsKeyDown(Keys.PageDown)) miekkoscWlosow += 0.01f;
            this.Window.Title = "Czy wywietlane futro: " + (czyWyswietlaneFutro ? "tak" : "nie") + ", dugo wosw: " + dlugoscWlosowFutra.ToString() + ", gsto futra: " + gestoscFutra.ToString() + ", mikko wosw: " + miekkoscWlosow.ToString();
            if(gestoscFutra!=poprzedniaGestoscFutra) efektFutra.Parameters["TeksturaFutra"].SetValue(StworzTekstureFutra(szerokoscTeksturyFutra,wysokoscTeksturyFutra,gestoscFutra));
            if(dlugoscWlosowFutra!=poprzedniaDlugoscWlosowFutra) efektFutra.Parameters["DlugoscWlosowFutra"].SetValue(dlugoscWlosowFutra);
            if(miekkoscWlosow!=poprzedniaMiekkoscWlosow) efektFutra.Parameters["MiekkoscWlosow"].SetValue(miekkoscWlosow);
            poprzedniaDlugoscWlosowFutra = dlugoscWlosowFutra;
            poprzedniaGestoscFutra = gestoscFutra;
            poprzedniaMiekkoscWlosow = miekkoscWlosow;

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            //czajniczek
            foreach (ModelMesh siatka in czajniczek.Meshes)
            {
                foreach (Effect efekt in siatka.Effects)
                {
                    siatka.Draw();
                }
            }

            //dude
            foreach (ModelMesh siatka in dude.Meshes)
            {
                foreach (Effect efekt in siatka.Effects)
                {
                    siatka.Draw();
                }
            }

            //dude-wlosy
            if (czyWyswietlaneFutro)
            {
                for (int i = 0; i < liczbaWarstw; ++i)
                {
                    efektFutra.Parameters["BiezacaWarstwa"].SetValue((float)i / liczbaWarstw);
                    foreach (ModelMesh siatka in dudeWlosy.Meshes)
                    {
                        foreach (Effect efekt in siatka.Effects)
                        {
                            siatka.Draw();
                        }
                    }
                }
            }

            base.Draw(gameTime);
        }
    }
}
