﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
//using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
//using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
//using Microsoft.Xna.Framework.Input;
//using Microsoft.Xna.Framework.Media;

using ITA106;

namespace Teren
{
    class Teren
    {
        GraphicsDevice gd;
        int szerokoscX, szerokoscY;
        float[,] wysokosc;
        float skalaX, skalaY, skalaZ;
        int iloscWerteksow, iloscWerteksowWCiaguTrojkatow;
        VertexBuffer buforWerteksow;
        IndexBuffer buforIndeksow;

        public Teren(GraphicsDevice gd, Texture2D mapaWysokosci, float skalaX, float skalaY, float skalaZ, Color kolor)
        {
            this.gd = gd;
            this.skalaX = skalaX;
            this.skalaY = skalaY;
            this.skalaZ = skalaZ;

            czytajWysokosciZTekstury(mapaWysokosci);
            tworzTeren(kolor);
            ustawIndeksy();
        }

        private void czytajWysokosciZTekstury(Texture2D mapaWysokosci)
        {
            //rozmiar
            szerokoscX = mapaWysokosci.Width;
            szerokoscY = mapaWysokosci.Height;
            iloscWerteksow = szerokoscX * szerokoscY;
            iloscWerteksowWCiaguTrojkatow = szerokoscX * 2;

            //czytanie danych
            Color[] koloryZMapyWysokosci = new Color[iloscWerteksow];
            mapaWysokosci.GetData<Color>(koloryZMapyWysokosci);
            wysokosc = new float[szerokoscX, szerokoscY];
            for (int x = 0; x < szerokoscX; ++x)
                for (int y = 0; y < szerokoscY; ++y)
                    wysokosc[x, y] = koloryZMapyWysokosci[x + y * szerokoscX].R; //tylko z R, inne potencjalnie do innych map
                    //wysokosc[x, y] = 100f * (float)(Math.Sin(0.1f * x) * Math.Sin(0.1f * y));
        }

        private void tworzTeren(Color kolor)
        {
            if (iloscWerteksow == 0) throw new Exception("Brak danych");

            VertexPositionColorNormalTexture[] werteksy = new VertexPositionColorNormalTexture[iloscWerteksow];
            Vector3 srodekMapy = new Vector3(skalaX * szerokoscX, skalaY * szerokoscY, 0) * 0.5f;
            Vector2 krokWspTeksturowania = new Vector2(1.0f/szerokoscX,1.0f/szerokoscY);
            for(int y=0;y<szerokoscY;++y)
                for (int x = 0; x < szerokoscX; ++x)
                {
                    //polozenie
                    Vector3 pozycja = new Vector3(skalaX * x, skalaY * y, skalaZ * wysokosc[x, y]);

                    //normalna
                    Vector3 p1, p2;
                    ustalPunktyTrojkata(x, y, out p1, out p2);
                    Vector3 normalna = ObliczNormalnaTrojkata(pozycja, p1, p2);
                    if (y != 0) //usrednianie normalnych z dwoch pasow
                    {
                        normalna += werteksy[x + (y - 1) * szerokoscX].Normal;
                        normalna.Normalize();
                    }

                    //wsp. teksturowania
                    Vector2 wspTeksturowania = new Vector2(x * krokWspTeksturowania.X, y * krokWspTeksturowania.Y);

                    werteksy[x + y * szerokoscX] =
                        new VertexPositionColorNormalTexture(
                            pozycja - srodekMapy, //oszustwo
                            kolor,
                            normalna,
                            wspTeksturowania);
                }

            buforWerteksow = new VertexBuffer(
                gd,
                VertexPositionColorNormalTexture.VertexDeclaration,
                iloscWerteksow,
                BufferUsage.WriteOnly);
            buforWerteksow.SetData<VertexPositionColorNormalTexture>(werteksy);
        }

        private void ustawIndeksy()
        {
            int[] indeksy = new int[(szerokoscY - 1) * iloscWerteksowWCiaguTrojkatow];
            for(int y=0;y<szerokoscY-1;++y)
            {
                int indeksDolny = y*szerokoscX;
                int indeksGorny = (y+1)*szerokoscX;
                for (int x = 0; x < iloscWerteksowWCiaguTrojkatow; x += 2)
                {
                    indeksy[y * iloscWerteksowWCiaguTrojkatow + x] = indeksGorny;
                    indeksGorny++;
                    indeksy[y * iloscWerteksowWCiaguTrojkatow + x + 1] = indeksDolny;
                    indeksDolny++;
                }
            }

            buforIndeksow = new IndexBuffer(gd, IndexElementSize.ThirtyTwoBits, (szerokoscY - 1) * iloscWerteksowWCiaguTrojkatow, BufferUsage.WriteOnly);
            buforIndeksow.SetData<int>(indeksy);
        }

        public void Rysuj(Effect efekt)
        {
            gd.SetVertexBuffer(buforWerteksow);
            gd.Indices = buforIndeksow;
            gd.RasterizerState = RasterizerState.CullNone;
            gd.SamplerStates[0] = SamplerState.LinearClamp;

            foreach (EffectPass przebieg in efekt.CurrentTechnique.Passes)
            {
                przebieg.Apply();
                for (int i = 0; i < szerokoscY - 1; ++i)
                {
                    gd.DrawIndexedPrimitives(
                        PrimitiveType.TriangleStrip,
                        0,
                        0,
                        iloscWerteksow,
                        i * iloscWerteksowWCiaguTrojkatow,
                        (szerokoscX - 1) * 2);
                }
            }
        }

        public static Vector3 ObliczNormalnaTrojkata(Vector3 pozycja, Vector3 p1, Vector3 p2)
        {
            Vector3 bok1 = p1 - pozycja;
            Vector3 bok2 = p2 - pozycja;
            Vector3 normalna = Vector3.Cross(bok2, bok1);
            normalna.Normalize();
            return normalna;
        }

        private void ustalPunktyTrojkata(int x, int y, out Vector3 p1, out Vector3 p2)
        {
            int x1, y1, x2, y2;
            if (x < szerokoscX - 1 && y < szerokoscY - 1)
            {
                x1 = x;
                y1 = y + 1;
                x2 = x + 1;
                y2 = y;
            }
            else if (x == szerokoscX - 1 && y < szerokoscY - 1)
            {
                x1 = x - 1;
                y1 = y;
                x2 = x;
                y2 = y + 1;
            }
            else if (y == szerokoscY - 1 && x < szerokoscX - 1)
            {
                x1 = x + 1;
                y1 = y;
                x2 = x;
                y2 = y - 1;
            }
            else
            {
                x1 = x;
                y1 = y - 1;
                x2 = x - 1;
                y2 = y;
            }
            p1 = new Vector3(skalaX * x1, skalaY * y1, skalaZ * wysokosc[x1, y1]);
            p2 = new Vector3(skalaX * x2, skalaY * y2, skalaZ * wysokosc[x2, y2]);
        }
    }
}
