using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Teren
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Texture2D mapaWysokosci;
        BasicEffect efekt;
        Teren teren;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            efekt = new BasicEffect(graphics.GraphicsDevice);
            efekt.World = Matrix.CreateRotationX(-MathHelper.PiOver4);
            efekt.Projection = Matrix.CreatePerspectiveFieldOfView(
                MathHelper.PiOver2,
                graphics.GraphicsDevice.Viewport.AspectRatio,
                1, 100);
            efekt.View = Matrix.CreateLookAt(
                10 * Vector3.UnitZ,
                Vector3.Zero,
                Vector3.Up);
            efekt.VertexColorEnabled = true;

            efekt.SpecularColor = Color.Black.ToVector3();
            efekt.EnableDefaultLighting();            

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            mapaWysokosci = Content.Load<Texture2D>("Heightmap");
            teren = new Teren(graphics.GraphicsDevice, mapaWysokosci, 0.05f, 0.05f, 0.01f, Color.Lime);

            efekt.Texture = mapaWysokosci;
            efekt.TextureEnabled = true;
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            KeyboardState stanKlawiatury = Keyboard.GetState();
            if(stanKlawiatury.IsKeyDown(Keys.Left)) efekt.World*=Matrix.CreateRotationY(0.01f);
            if(stanKlawiatury.IsKeyDown(Keys.Right)) efekt.World*=Matrix.CreateRotationY(-0.01f);
            if(stanKlawiatury.IsKeyDown(Keys.Up)) efekt.World*=Matrix.CreateRotationX(0.01f);
            if(stanKlawiatury.IsKeyDown(Keys.Down)) efekt.World*=Matrix.CreateRotationX(-0.01f);

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            teren.Rysuj(efekt);

            base.Draw(gameTime);
        }
    }
}
