﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
//using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
//using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
//using Microsoft.Xna.Framework.Input;
//using Microsoft.Xna.Framework.Media;

using ITA106;

namespace Teren
{
    class Teren
    {
        GraphicsDevice gd;
        int szerokoscX, szerokoscY;
        float[,] wysokosc;
        float skalaX, skalaY, skalaZ;
        int iloscWerteksow, iloscWerteksowWCiaguTrojkatow;
        VertexBuffer buforWerteksow;
        IndexBuffer buforIndeksow;

        public Teren(GraphicsDevice gd, Texture2D mapaWysokosci, float skalaX, float skalaY, float skalaZ, Color kolor)
        {
            this.gd = gd;
            this.skalaX = skalaX;
            this.skalaY = skalaY;
            this.skalaZ = skalaZ;

            czytajWysokosciZTekstury(mapaWysokosci);
            tworzTeren(kolor);
            ustawIndeksy();
        }

        private void czytajWysokosciZTekstury(Texture2D mapaWysokosci)
        {
            //rozmiar
            szerokoscX = mapaWysokosci.Width;
            szerokoscY = mapaWysokosci.Height;
            iloscWerteksow = szerokoscX * szerokoscY;
            iloscWerteksowWCiaguTrojkatow = szerokoscX * 2;

            //czytanie danych
            Color[] koloryZMapyWysokosci = new Color[iloscWerteksow];
            mapaWysokosci.GetData<Color>(koloryZMapyWysokosci);
            wysokosc = new float[szerokoscX, szerokoscY];
            for(int x=0;x<szerokoscX;++x)
                for (int y = 0; y < szerokoscY; ++y)
                    wysokosc[x, y] = koloryZMapyWysokosci[x + y * szerokoscX].R; //tylko z R, inne potencjalnie do innych map
        }

        private void tworzTeren(Color kolor)
        {
            if (iloscWerteksow == 0) throw new Exception("Brak danych");

            VertexPositionColorNormalTexture[] werteksy = new VertexPositionColorNormalTexture[iloscWerteksow];
            Vector3 srodekMapy = new Vector3(skalaX * szerokoscX, skalaY * szerokoscY, 0) * 0.5f;
            for(int y=0;y<szerokoscY;++y)
                for (int x = 0; x < szerokoscX; ++x)
                {
                    Vector3 pozycja = new Vector3(skalaX * x, skalaY * y, skalaZ * wysokosc[x, y]);
                    werteksy[x + y * szerokoscX] =
                        new VertexPositionColorNormalTexture(
                            pozycja - srodekMapy, //oszustwo
                            kolor,
                            Vector3.UnitZ,
                            Vector2.Zero);
                }

            buforWerteksow = new VertexBuffer(
                gd,
                VertexPositionColorNormalTexture.VertexDeclaration,
                iloscWerteksow,
                BufferUsage.WriteOnly);
            buforWerteksow.SetData<VertexPositionColorNormalTexture>(werteksy);
        }

        private void ustawIndeksy()
        {
            int[] indeksy = new int[(szerokoscY - 1) * iloscWerteksowWCiaguTrojkatow];
            for(int y=0;y<szerokoscY-1;++y)
            {
                int indeksDolny = y*szerokoscX;
                int indeksGorny = (y+1)*szerokoscX;
                for (int x = 0; x < iloscWerteksowWCiaguTrojkatow; x += 2)
                {
                    indeksy[y * iloscWerteksowWCiaguTrojkatow + x] = indeksGorny;
                    indeksGorny++;
                    indeksy[y * iloscWerteksowWCiaguTrojkatow + x + 1] = indeksDolny;
                    indeksDolny++;
                }
            }

            buforIndeksow = new IndexBuffer(gd, IndexElementSize.SixteenBits, (szerokoscY - 1) * iloscWerteksowWCiaguTrojkatow, BufferUsage.WriteOnly);
            buforIndeksow.SetData<int>(indeksy);
        }

        public void Rysuj(Effect efekt)
        {
            gd.SetVertexBuffer(buforWerteksow);
            gd.Indices = buforIndeksow;
            gd.RasterizerState = RasterizerState.CullNone;
            gd.SamplerStates[0] = SamplerState.LinearClamp;

            foreach (EffectPass przebieg in efekt.CurrentTechnique.Passes)
            {
                przebieg.Apply();
                for (int i = 0; i < szerokoscY - 1; ++i)
                {
                    gd.DrawIndexedPrimitives(
                        PrimitiveType.TriangleStrip,
                        0,
                        0,
                        iloscWerteksow,
                        i * iloscWerteksowWCiaguTrojkatow,
                        (szerokoscX - 1) * 2);
                }
            }
        }
    }
}
