﻿    using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Stereoscopy
{
    public struct VertexPositionColorNormal
    {
        public Vector3 Position;
        public Color Color;
        public Vector3 Normal;

        public VertexPositionColorNormal(Vector3 Position, Color Color, Vector3 Normal)
        {
            this.Position = Position;
            this.Color = Color;
            this.Normal = Normal;
        }

        public static readonly VertexDeclaration VertexDeclaration = new VertexDeclaration(
            new VertexElement(0,VertexElementFormat.Vector3,VertexElementUsage.Position,0),
            new VertexElement(3*sizeof(float),VertexElementFormat.Color,VertexElementUsage.Color,0),
            new VertexElement(3*sizeof(float)+sizeof(uint),VertexElementFormat.Vector3,VertexElementUsage.Normal,0)
            );
    }

    public struct VertexPositionColorNormalTexture
    {
        public Vector3 Position;
        public Color Color;
        public Vector3 Normal;
        public Vector2 TextureCoordinates;

        public VertexPositionColorNormalTexture(Vector3 Position, Color Color, Vector3 Normal, Vector2 TextureCoordinates)
        {
            this.Position = Position;
            this.Color = Color;
            this.Normal = Normal;
            this.TextureCoordinates = TextureCoordinates;
        }

        public static readonly VertexDeclaration VertexDeclaration = new VertexDeclaration(
            new VertexElement(0, VertexElementFormat.Vector3, VertexElementUsage.Position, 0),
            new VertexElement(3 * sizeof(float), VertexElementFormat.Color, VertexElementUsage.Color, 0),
            new VertexElement(3 * sizeof(float) + sizeof(uint), VertexElementFormat.Vector3, VertexElementUsage.Normal, 0),
            new VertexElement(6 * sizeof(float) + sizeof(uint), VertexElementFormat.Vector2, VertexElementUsage.TextureCoordinate, 0)
            );
    }

    public struct VertexPositionDualTexture : IVertexType
    {
        public Vector3 Position;
        public Vector2 TextureCoordinates;
        public Vector2 TextureCoordinates2;

        public VertexPositionDualTexture(Vector3 Position, Vector2 TextureCoordinates, Vector2 TextureCoordinates2)
        {
            this.Position = Position;
            this.TextureCoordinates = TextureCoordinates;
            this.TextureCoordinates2 = TextureCoordinates2;
        }

        public static readonly VertexDeclaration VertexDeclaration = new VertexDeclaration(
            new VertexElement(0, VertexElementFormat.Vector3, VertexElementUsage.Position, 0),
            new VertexElement(3 * sizeof(float), VertexElementFormat.Vector2, VertexElementUsage.TextureCoordinate, 0),
            new VertexElement(5 * sizeof(float), VertexElementFormat.Vector2, VertexElementUsage.TextureCoordinate, 1)
            );

        VertexDeclaration IVertexType.VertexDeclaration
        {
            get
            {
                return VertexDeclaration;
            }
        }
    }
}
