﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Stereoscopy
{
    class Cube
    {
        private GraphicsDevice gd = null;
        private VertexBuffer vertexBuffer = null;

        private BasicEffect effect = null;
        public Matrix World = Matrix.Identity;
        public Matrix View = Matrix.Identity;

        public bool IsVisible = true;

        public Cube(GraphicsDevice gd, BasicEffect effect, Texture2D texture, float dx, float dy, float dz, Vector3 translation)
        {
            
            dx /= 2;
            dy /= 2;
            dz /= 2;

            this.gd = gd;

            this.effect = (BasicEffect)effect.Clone();

            Vector2[] textureCordinate = new Vector2[4]{
                new Vector2(0,0),
                new Vector2(0,1),
                new Vector2(1,0),
                new Vector2(1,1)
            };
            
            Vector3[] punkty = new Vector3[8]{
                new Vector3(-dx, -dy, dz),
                new Vector3(dx, -dy, dz),
                new Vector3(dx, dy, dz),
                new Vector3(-dx, dy, dz),
                new Vector3(-dx, -dy, -dz),
                new Vector3(dx, -dy, -dz),
                new Vector3(dx, dy, -dz),
                new Vector3(-dx, dy, -dz)};

            for (int i = 0; i < punkty.Count(); ++i) punkty[i] += translation;

            VertexPositionNormalTexture[] vertices = new VertexPositionNormalTexture[6 * 4]
            {
                //front face
                new VertexPositionNormalTexture(punkty[3], Vector3.UnitZ, textureCordinate[0]),
                new VertexPositionNormalTexture(punkty[2], Vector3.UnitZ, textureCordinate[2]),
                new VertexPositionNormalTexture(punkty[0], Vector3.UnitZ, textureCordinate[1]),
                new VertexPositionNormalTexture(punkty[1], Vector3.UnitZ, textureCordinate[3]),
           
                //back face
                new VertexPositionNormalTexture(punkty[7], -Vector3.UnitZ, textureCordinate[2]),
                new VertexPositionNormalTexture(punkty[4], -Vector3.UnitZ, textureCordinate[3]),
                new VertexPositionNormalTexture(punkty[6], -Vector3.UnitZ, textureCordinate[0]),
                new VertexPositionNormalTexture(punkty[5], -Vector3.UnitZ, textureCordinate[1]),
   
                //upper face
                new VertexPositionNormalTexture(punkty[3], Vector3.UnitY, textureCordinate[1]),
                new VertexPositionNormalTexture(punkty[7], Vector3.UnitY, textureCordinate[0]),
                new VertexPositionNormalTexture(punkty[2], Vector3.UnitY, textureCordinate[3]),
                new VertexPositionNormalTexture(punkty[6], Vector3.UnitY, textureCordinate[2]),

                //lower face
                new VertexPositionNormalTexture(punkty[0], -Vector3.UnitY, textureCordinate[0]),
                new VertexPositionNormalTexture(punkty[1], -Vector3.UnitY, textureCordinate[2]),
                new VertexPositionNormalTexture(punkty[4], -Vector3.UnitY, textureCordinate[1]),
                new VertexPositionNormalTexture(punkty[5], -Vector3.UnitY, textureCordinate[3]),
   
                //left face
                new VertexPositionNormalTexture(punkty[3], -Vector3.UnitX, textureCordinate[2]),
                new VertexPositionNormalTexture(punkty[0], -Vector3.UnitX, textureCordinate[3]),
                new VertexPositionNormalTexture(punkty[7], -Vector3.UnitX, textureCordinate[0]),
                new VertexPositionNormalTexture(punkty[4], -Vector3.UnitX, textureCordinate[1]),

                //right face
                new VertexPositionNormalTexture(punkty[1], Vector3.UnitX, textureCordinate[1]),
                new VertexPositionNormalTexture(punkty[2], Vector3.UnitX, textureCordinate[0]),
                new VertexPositionNormalTexture(punkty[5], Vector3.UnitX, textureCordinate[3]),
                new VertexPositionNormalTexture(punkty[6], Vector3.UnitX, textureCordinate[2])
            };            

            vertexBuffer = new VertexBuffer(gd, typeof(VertexPositionNormalTexture), vertices.Count(), BufferUsage.WriteOnly);
            vertexBuffer.SetData<VertexPositionNormalTexture>(vertices);

            effect.Texture = texture;
            effect.TextureEnabled = true;
        }

        public void Draw(Color color)
        {
            //Update
            effect.World = World;
            effect.View = View;

            effect.AmbientLightColor = color.ToVector3();
            //effect.DiffuseColor = color.ToVector3();
            effect.SpecularColor = color.ToVector3();

            //Draw
            if (IsVisible)
            {
                gd.SetVertexBuffer(vertexBuffer);

                foreach (EffectPass pass in effect.CurrentTechnique.Passes)
                {
                    pass.Apply();
                    for(int i=0;i<6;++i)
                        gd.DrawPrimitives(PrimitiveType.TriangleStrip, 4*i, 2);
                }
            }
        }
    }
}
