﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace Stereoscopy
{
    class BigCube 
    {
        List<Cube> cubes;

        //creating of 27 cubes
        public BigCube(GraphicsDevice gd, BasicEffect effect, Texture2D texture)
        {
            cubes = new List<Cube>();
            for (int x = -1; x < 2; x++)
            {
                for (int y = -1; y < 2; y++)
                {
                    for (int z = -1; z < 2; z++)
                    {
                        Cube cube = new Cube(gd, effect, texture, 1, 1, 1, new Vector3(x,y,z));
                        cube.World = Matrix.Identity;
                        cubes.Add(cube);
                    }
                }
            }
        }

        public void Draw(Color color)
        {
            foreach (Cube cube in cubes) cube.Draw(color);
        }

        public Matrix View
        {
            set
            {
                foreach (Cube cube in cubes) cube.View = value;
            }
        }

        public Matrix World
        {
            set
            {
                foreach (Cube cube in cubes) cube.World = value;
            }
        }

        public void TransformView(Matrix transformation)
        {
            foreach (Cube cube in cubes) cube.View *= transformation;
        }

        public void TransformWorld(Matrix transformation)
        {
            foreach (Cube cube in cubes) cube.World *= transformation;
        }

        private void ResetShape()
        {
            foreach (Cube cube in cubes) cube.IsVisible = false;
        }

        public void SetCubeShape()
        {
            ResetShape();
            foreach (Cube cube in cubes) cube.IsVisible = true;
        }

        public void SetStarShape()
        {
            ResetShape();
            cubes.ElementAt<Cube>(22).IsVisible = true;
            cubes.ElementAt<Cube>(12).IsVisible = true;
            cubes.ElementAt<Cube>(13).IsVisible = true;
            cubes.ElementAt<Cube>(14).IsVisible = true;
            cubes.ElementAt<Cube>(10).IsVisible = true;
            cubes.ElementAt<Cube>(16).IsVisible = true;
            cubes.ElementAt<Cube>(4).IsVisible = true;
        }

        public void SetStairsShape()
        {
            ResetShape();
            cubes.ElementAt<Cube>(18).IsVisible = true;
            cubes.ElementAt<Cube>(21).IsVisible = true;
            cubes.ElementAt<Cube>(24).IsVisible = true;
            cubes.ElementAt<Cube>(10).IsVisible = true;
            cubes.ElementAt<Cube>(13).IsVisible = true;
            cubes.ElementAt<Cube>(16).IsVisible = true;
            cubes.ElementAt<Cube>(2).IsVisible = true;
            cubes.ElementAt<Cube>(5).IsVisible = true;
            cubes.ElementAt<Cube>(8).IsVisible = true;
        }

        public void SetXShape()
        {
            ResetShape();
            cubes.ElementAt<Cube>(24).IsVisible = true;
            cubes.ElementAt<Cube>(20).IsVisible = true;
            cubes.ElementAt<Cube>(13).IsVisible = true;
            cubes.ElementAt<Cube>(0).IsVisible = true;
            cubes.ElementAt<Cube>(8).IsVisible = true;
        }

        public void SetPShape()
        {
            ResetShape();
            cubes.ElementAt<Cube>(22).IsVisible = true;
            cubes.ElementAt<Cube>(2).IsVisible = true;
            cubes.ElementAt<Cube>(6).IsVisible = true;
            cubes.ElementAt<Cube>(0).IsVisible = true;
            cubes.ElementAt<Cube>(8).IsVisible = true;
        }

        public void SetOShape()
        {
            ResetShape();
            cubes.ElementAt<Cube>(9).IsVisible = true;
            cubes.ElementAt<Cube>(12).IsVisible = true;
            cubes.ElementAt<Cube>(15).IsVisible = true;
            cubes.ElementAt<Cube>(10).IsVisible = true;
            cubes.ElementAt<Cube>(16).IsVisible = true;
            cubes.ElementAt<Cube>(11).IsVisible = true;
            cubes.ElementAt<Cube>(14).IsVisible = true;
            cubes.ElementAt<Cube>(17).IsVisible = true;
        }

        public void SetTShape()
        {
            ResetShape();
            cubes.ElementAt<Cube>(21).IsVisible = true;
            cubes.ElementAt<Cube>(22).IsVisible = true;
            cubes.ElementAt<Cube>(23).IsVisible = true;
            cubes.ElementAt<Cube>(19).IsVisible = true;
            cubes.ElementAt<Cube>(25).IsVisible = true;
            cubes.ElementAt<Cube>(13).IsVisible = true;
            cubes.ElementAt<Cube>(4).IsVisible = true;
        }
    }
}
