using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using System.Threading.Tasks; //TPL

namespace Stereoscopy
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        GraphicsDevice gd;
        BasicEffect effect;

        BigCube solid;

        bool isRotating = true;

        readonly Vector3 cameraDefaultPosition = new Vector3(1f, 1f, 4.5f);

        float odchylenie = 0.08f;        
        Matrix viewLeft = Matrix.Identity;
        Matrix viewRight = Matrix.Identity;

        RenderTarget2D renderTargetLeft, renderTargetRight;

        Vector3 filterLeft = new Vector3(1, 0, 0);
        Vector3 filterRight = new Vector3(0, 1, 1);

        bool cameraEnabledLeft = true;
        bool cameraEnabledRight = true;
        bool showSeparateViews = true;

        Effect combinationingEffect;
        VertexPositionTexture[] werteksyEkranu = new VertexPositionTexture[4]
        {
            new VertexPositionTexture(new Vector3(-1,1,0),new Vector2(0,0)),
            new VertexPositionTexture(new Vector3(1,1,0),new Vector2(1,0)),
            new VertexPositionTexture(new Vector3(-1,-1,0),new Vector2(0,1)),
            new VertexPositionTexture(new Vector3(1,-1,0),new Vector2(1,1))
        };

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }
       
        protected override void Initialize()
        {
            gd = graphics.GraphicsDevice;
            PresentationParameters pp = gd.PresentationParameters;

            renderTargetLeft = new RenderTarget2D(gd, pp.BackBufferWidth, pp.BackBufferHeight, false, gd.DisplayMode.Format, DepthFormat.Depth24);
            renderTargetRight = new RenderTarget2D(gd, pp.BackBufferWidth, pp.BackBufferHeight, false, gd.DisplayMode.Format, DepthFormat.Depth24);

            effect = new BasicEffect(gd);
            effect.VertexColorEnabled = false;
            effect.Projection = Matrix.CreatePerspective(2.0f * gd.Viewport.AspectRatio, 2.0f, 1.0f, 100.0f);            
            //effect.View = Matrix.CreateLookAt(cameraDefaultPosition, Vector3.Zero, Vector3.Up);
            effect.EnableDefaultLighting();

            viewLeft = Matrix.CreateLookAt(cameraDefaultPosition - Vector3.UnitX * odchylenie, Vector3.Zero, Vector3.Up);
            viewRight = Matrix.CreateLookAt(cameraDefaultPosition + Vector3.UnitX * odchylenie, Vector3.Zero, Vector3.Up);

            base.Initialize();
        }

       
        protected override void LoadContent()
        {
            solid = new BigCube(gd, effect, Content.Load<Texture2D>("CubeTexture"));
            solid.SetXShape();
            spriteBatch = new SpriteBatch(gd);

            combinationingEffect = Content.Load<Effect>("CombinationingEffect");
        }

       
        protected override void UnloadContent()
        {
        }

        KeyboardState previousKeyboardState = Keyboard.GetState();

        protected override void Update(GameTime gameTime)
        {
           
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            //keyboard
            KeyboardState keyboardState = Keyboard.GetState();
            if (keyboardState.IsKeyDown(Keys.Escape)) this.Exit();
            if (keyboardState.IsKeyDown(Keys.Space) && !previousKeyboardState.IsKeyDown(Keys.Space))
            {
                try
                {
                    graphics.ToggleFullScreen();
                }
                catch
                {                    
                }
            }

            float verticalRotation = 0.0f;
            float horizontalRotation = 0.0f;
            if (keyboardState.IsKeyDown(Keys.Up)) verticalRotation = -0.02f;
            if (keyboardState.IsKeyDown(Keys.Down)) verticalRotation = 0.02f;
            if (keyboardState.IsKeyDown(Keys.Right)) horizontalRotation = 0.02f;
            if (keyboardState.IsKeyDown(Keys.Left)) horizontalRotation = -0.02f;
            Quaternion aditionalRotation = Quaternion.CreateFromAxisAngle(new Vector3(1, 0, 0), verticalRotation) *
                                           Quaternion.CreateFromAxisAngle(new Vector3(0, 1, 0), horizontalRotation);

            if (keyboardState.IsKeyDown(Keys.F1)) solid.SetStarShape();
            if (keyboardState.IsKeyDown(Keys.F2)) solid.SetStairsShape();
            if (keyboardState.IsKeyDown(Keys.F3)) solid.SetXShape();
            if (keyboardState.IsKeyDown(Keys.F4)) solid.SetPShape();
            if (keyboardState.IsKeyDown(Keys.F5)) solid.SetOShape();
            if (keyboardState.IsKeyDown(Keys.F6)) solid.SetTShape();
            if (keyboardState.IsKeyDown(Keys.F7)) solid.SetCubeShape();

            if (keyboardState.IsKeyDown(Keys.D0) && !previousKeyboardState.IsKeyDown(Keys.D0)) isRotating = !isRotating;

            bool viewChanged = false;
            if (keyboardState.IsKeyDown(Keys.OemComma))
            {
                odchylenie -= 0.01f;
                viewChanged = true;
            }
            if (keyboardState.IsKeyDown(Keys.OemPeriod))
            {
                odchylenie += 0.01f;
                viewChanged = true;
            }
            if (viewChanged)
            {
                viewLeft = Matrix.CreateLookAt(cameraDefaultPosition - Vector3.UnitX * odchylenie, Vector3.Zero, Vector3.Up);
                viewRight = Matrix.CreateLookAt(cameraDefaultPosition + Vector3.UnitX * odchylenie, Vector3.Zero, Vector3.Up);
            }

            previousKeyboardState = keyboardState;

            //rotations    
            Matrix transformation;
            if (!isRotating)
            {
                transformation = Matrix.CreateFromQuaternion(aditionalRotation);
            }
            else
            {
                transformation = Matrix.CreateRotationX(gameTime.ElapsedGameTime.Milliseconds / 1000.0f)
                   * Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);
            }
            if (keyboardState.IsKeyDown(Keys.OemPlus)) transformation *= Matrix.CreateScale(1.01f);
            if (keyboardState.IsKeyDown(Keys.OemMinus)) transformation *= Matrix.CreateScale(0.99f);
            solid.TransformWorld(transformation);

            solid.View = effect.View;
            
            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            /*
            gd.Clear(Color.Black);
            solid.Draw();
            */

            //left camera
            gd.SetRenderTarget(renderTargetLeft);
            gd.Clear(Color.Black);
            if (cameraEnabledLeft)
            {
                solid.View = viewLeft;
                solid.Draw();
            }
            gd.SetRenderTarget(null);

            //right camera
            gd.SetRenderTarget(renderTargetRight);
            gd.Clear(Color.Black);
            if (cameraEnabledRight)
            {
                solid.View = viewRight;
                solid.Draw();
            }
            gd.SetRenderTarget(null);


            //combining
            Color[] imageLeft = new Color[renderTargetLeft.Width * renderTargetLeft.Height];
            renderTargetLeft.GetData<Color>(imageLeft);
            Color[] imageRight = new Color[renderTargetRight.Width * renderTargetRight.Height];
            renderTargetRight.GetData<Color>(imageRight);
            
            
            //for (int i = 0; i < imageRight.Count(); ++i) imageRight[i] = new Color(imageLeft[i].ToVector3() * filterLeft + imageRight[i].ToVector3() * filterRight);
            Parallel.For(
                0,
                imageRight.Count(),
                i => { imageRight[i] = new Color(imageLeft[i].ToVector3() * filterLeft + imageRight[i].ToVector3() * filterRight); }
                );
            
            Texture2D combination = new Texture2D(gd, renderTargetLeft.Width, renderTargetLeft.Height);
            combination.SetData<Color>(imageRight);

            spriteBatch.Begin(SpriteSortMode.Immediate, BlendState.Opaque, null, DepthStencilState.Default, null);
            spriteBatch.Draw(combination, new Rectangle(0,0,Window.ClientBounds.Width,Window.ClientBounds.Height), Color.White);

            if (showSeparateViews)
            {
                spriteBatch.Draw(renderTargetLeft, new Rectangle(0, 0, Window.ClientBounds.Width / 4, Window.ClientBounds.Height / 4), Color.White);
                spriteBatch.Draw(renderTargetRight, new Rectangle(3 * Window.ClientBounds.Width / 4, 0, Window.ClientBounds.Width / 4, Window.ClientBounds.Height / 4), Color.White);
            }
            spriteBatch.End();
            
            base.Draw(gameTime);
        }
    }
}
