texture TextureLeft;
sampler TextureSamplerLeft = sampler_state
{
	texture = TextureLeft;
	magfilter = POINT;
	minfilter = POINT;
	mipfilter = POINT;
	AddressU = Clamp;
	AddressV = Clamp;
};

texture TextureRight;
sampler TextureSamplerRight = sampler_state
{
	texture = TextureRight;
	magfilter = POINT;
	minfilter = POINT;
	mipfilter = POINT;
	AddressU = Clamp;
	AddressV = Clamp;
};

float3 filterLeft = float3(1,0,0);
float3 filterRight = float3(0,1,1);

struct Vertex
{
	float4 Position : POSITION0; //nie uzywane
	float2 TexCoord : TEXCOORD0;
};

Vertex VS(Vertex input)
{
	/*
	Vertex output;
	output.Position = input.Position;
	output.TexCoord = input.TexCoord;
	return output;
	*/
	return input;
}

float4 PS(Vertex input) : COLOR
{
	float4 texelLeft = tex2D(TextureSamplerLeft,input.TexCoord);
	float4 texelRight = tex2D(TextureSamplerRight,input.TexCoord);

	float4 color;
	color.rgb = filterLeft*texelLeft+filterRight*texelRight;
	color.a = 1;

	return color;
}

technique Technique1
{
	pass Pass0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}