using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;


namespace ITA106
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class Prostopadloscian : Microsoft.Xna.Framework.DrawableGameComponent
    {

        private GraphicsDevice gd = null;
        private VertexBuffer buforWerteksow = null;

        private BasicEffect efekt = null;
        public Matrix World = Matrix.Identity;

        public Prostopadloscian(Game game,BasicEffect efekt,float dx,float dy,float dz,Color? kolor)
            : base(game)
        {
            dx /= 2;
            dy /= 2;
            dz /= 2;

            gd = game.GraphicsDevice;

            this.efekt = (BasicEffect)efekt.Clone();

            Vector3[] punkty = new Vector3[8]{
                new Vector3(-dx, -dy, dz),
                new Vector3(dx, -dy, dz),
                new Vector3(dx, dy, dz),
                new Vector3(-dx, dy, dz),
                new Vector3(-dx, -dy, -dz),
                new Vector3(dx, -dy, -dz),
                new Vector3(dx, dy, -dz),
                new Vector3(-dx, dy, -dz)};

            Color kolor1 = (kolor == null) ? Color.Cyan : (Color)kolor;
            Color kolor2 = (kolor == null) ? Color.Magenta : (Color)kolor;
            Color kolor3 = (kolor == null) ? Color.Yellow : (Color)kolor;

            VertexPositionColorNormal[] werteksy = new VertexPositionColorNormal[6 * 2 * 3]{
                //przednia sciana
                new VertexPositionColorNormal(punkty[3], kolor1, Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[2], kolor1, Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[0], kolor1, Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[0], kolor1, Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[2], kolor1, Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[1], kolor1, Vector3.UnitZ),

                //tylnia sciana
                new VertexPositionColorNormal(punkty[7], kolor1, -Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[4], kolor1, -Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[6], kolor1, -Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[6], kolor1, -Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[4], kolor1, -Vector3.UnitZ),
                new VertexPositionColorNormal(punkty[5], kolor1, -Vector3.UnitZ),
   
                //gorna sciana
                new VertexPositionColorNormal(punkty[3], kolor2, Vector3.UnitY),
                new VertexPositionColorNormal(punkty[7], kolor2, Vector3.UnitY),
                new VertexPositionColorNormal(punkty[2], kolor2, Vector3.UnitY),
                new VertexPositionColorNormal(punkty[2], kolor2, Vector3.UnitY),
                new VertexPositionColorNormal(punkty[7], kolor2, Vector3.UnitY),
                new VertexPositionColorNormal(punkty[6], kolor2, Vector3.UnitY),

                //dolna sciana
                new VertexPositionColorNormal(punkty[0], kolor2, -Vector3.UnitY),
                new VertexPositionColorNormal(punkty[1], kolor2, -Vector3.UnitY),
                new VertexPositionColorNormal(punkty[4], kolor2, -Vector3.UnitY),
                new VertexPositionColorNormal(punkty[4], kolor2, -Vector3.UnitY),
                new VertexPositionColorNormal(punkty[1], kolor2, -Vector3.UnitY),
                new VertexPositionColorNormal(punkty[5], kolor2, -Vector3.UnitY),
   
                //lewa sciana
                new VertexPositionColorNormal(punkty[3], kolor3, -Vector3.UnitX),
                new VertexPositionColorNormal(punkty[0], kolor3, -Vector3.UnitX),
                new VertexPositionColorNormal(punkty[7], kolor3, -Vector3.UnitX),
                new VertexPositionColorNormal(punkty[7], kolor3, -Vector3.UnitX),
                new VertexPositionColorNormal(punkty[0], kolor3, -Vector3.UnitX),
                new VertexPositionColorNormal(punkty[4], kolor3, -Vector3.UnitX),

                //prawa sciana
                new VertexPositionColorNormal(punkty[1], kolor3, Vector3.UnitX),
                new VertexPositionColorNormal(punkty[2], kolor3, Vector3.UnitX),
                new VertexPositionColorNormal(punkty[5], kolor3, Vector3.UnitX),
                new VertexPositionColorNormal(punkty[5], kolor3, Vector3.UnitX),
                new VertexPositionColorNormal(punkty[2], kolor3, Vector3.UnitX),
                new VertexPositionColorNormal(punkty[6], kolor3, Vector3.UnitX)};

            buforWerteksow = new VertexBuffer(gd, VertexPositionColorNormal.VertexDeclaration, werteksy.Count(), BufferUsage.WriteOnly);
            buforWerteksow.SetData<VertexPositionColorNormal>(werteksy);
        }

        /// <summary>
        /// Allows the game component to perform any initialization it needs to before starting
        /// to run.  This is where it can query for any required services and load content.
        /// </summary>
        public override void Initialize()
        {
            // TODO: Add your initialization code here

            base.Initialize();
        }

        /// <summary>
        /// Allows the game component to update itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        public override void Update(GameTime gameTime)
        {
            efekt.World = World;

            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            gd.SetVertexBuffer(buforWerteksow);

            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Apply();                
                gd.DrawPrimitives(PrimitiveType.TriangleList, 0, 6 * 2);
            }

            base.Draw(gameTime);
        }
    }
}