using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace DrugiProjekt
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        BasicEffect efekt;

        Texture2D tekstura;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            this.IsMouseVisible = true;

            GraphicsDevice.RasterizerState = RasterizerState.CullNone;

            efekt = new BasicEffect(GraphicsDevice);
            efekt.VertexColorEnabled = true;
            efekt.World = Matrix.Identity;
            efekt.View = Matrix.CreateLookAt(
                new Vector3(0, 0, 3),
                Vector3.Zero,
                new Vector3(0, 1, 0));
            efekt.Projection = Matrix.CreatePerspective(
                2f * graphics.GraphicsDevice.Viewport.AspectRatio,
                2,
                1,
                100);

            efekt.EnableDefaultLighting();
            efekt.PreferPerPixelLighting = true;
            //efekt.AmbientLightColor = Color.Black.ToVector3();
            //efekt.DirectionalLight0.SpecularColor = Color.Red.ToVector3();
            //efekt.DirectionalLight1.SpecularColor = Color.Green.ToVector3();
            //efekt.DirectionalLight2.SpecularColor = Color.Blue.ToVector3();
            //efekt.DirectionalLight0.DiffuseColor = Color.Red.ToVector3();
            //efekt.DirectionalLight1.DiffuseColor = Color.Green.ToVector3();
            //efekt.DirectionalLight2.DiffuseColor = Color.Blue.ToVector3();

            efekt.AmbientLightColor = Color.Gray.ToVector3();
            efekt.DirectionalLight0.SpecularColor = Color.Black.ToVector3();
            efekt.DirectionalLight1.SpecularColor = Color.Black.ToVector3();
            efekt.DirectionalLight2.SpecularColor = Color.Black.ToVector3();
            efekt.DirectionalLight0.DiffuseColor = Color.White.ToVector3();
            efekt.DirectionalLight1.DiffuseColor = Color.White.ToVector3();
            efekt.DirectionalLight2.DiffuseColor = Color.White.ToVector3();

            efekt.DiffuseColor = Color.White.ToVector3();
            efekt.SpecularColor = Color.White.ToVector3();
            efekt.SpecularPower = 10;


            BasicEffect efektLewy = (BasicEffect)efekt.Clone();
            efektLewy.View *= Matrix.CreateTranslation(-1.5f, 0, 0);
            this.Components.Add(new Prostopadloscian(this, efektLewy, 1.5f, 1, 2, Color.White));

            BasicEffect efektPrawy = (BasicEffect)efekt.Clone();
            efektPrawy.View *= Matrix.CreateTranslation(1.5f, 0, 0);
            this.Components.Add(new Prostopadloscian(this, efektPrawy, 1.5f, 1, 2, Color.Chocolate));

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            tekstura = Content.Load<Texture2D>("Tekstura");

            /*
            Color purpura = new Color(255,0,255,255);
            //Color czern = new Color(0, 0, 0, 255);            
            int rozmiar = tekstura.Width*tekstura.Height;
            Color[] teksele = new Color[rozmiar];
            tekstura.GetData<Color>(teksele);
            for(int i=0; i<rozmiar; ++i)            
            {
                //if (teksele[i] == purpura) teksele[i] = Color.Yellow;
                if (teksele[i] == purpura)
                {
                    teksele[i].R = 0;
                    teksele[i].A = 128;
                }
            }
            tekstura.SetData<Color>(teksele);
            */
            //zamiast tego: ustawienia w Content Preprocessor tekstury

            GraphicsDevice.BlendState = BlendState.AlphaBlend;

            //efekt.Texture = tekstura;
            //efekt.TextureEnabled = true;            

            foreach (DrawableGameComponent gc in this.Components)
            {
                if (gc is Prostopadloscian)
                {
                    Prostopadloscian p = (gc as Prostopadloscian);
                    p.Tekstura = tekstura;
                    p.TeksturowanieWlaczone = true;
                }
            }
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            // TODO: Add your drawing code here

            base.Draw(gameTime);
        }
    }
}
