using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace SzostaGra_Model
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        BasicEffect efekt;
        Model czajniczek;

        public Game1()
        {
            this.IsMouseVisible = true;

            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            efekt = new BasicEffect(this.GraphicsDevice);
            efekt.World = Matrix.Identity;
            efekt.View = Matrix.CreateLookAt(new Vector3(0, 0, 2.5f), Vector3.Zero, Vector3.Up);
            efekt.Projection = Matrix.CreatePerspective(
                2f * graphics.GraphicsDevice.Viewport.AspectRatio,
                2f,
                1f,
                100f);            

            efekt.PreferPerPixelLighting = true;
            efekt.EnableDefaultLighting();                        

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            czajniczek = Content.Load<Model>("teapot");
            this.Window.Title = "Ilo siatek: " + czajniczek.Meshes.Count.ToString();
            foreach (ModelMesh siatka in czajniczek.Meshes)
            {
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    czescSiatki.Effect = efekt;
                }
            }
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            KeyboardState stanKlawiatury = Keyboard.GetState();
            Matrix macierzObrotu = Matrix.Identity;
            if (stanKlawiatury.IsKeyDown(Keys.Left)) macierzObrotu *= Matrix.CreateRotationY((float)(-2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.Right)) macierzObrotu *= Matrix.CreateRotationY((float)(2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.Up)) macierzObrotu *= Matrix.CreateRotationX((float)(-2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.Down)) macierzObrotu *= Matrix.CreateRotationX((float)(2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.OemComma)) macierzObrotu *= Matrix.CreateRotationZ((float)(2 * gameTime.ElapsedGameTime.TotalSeconds));
            if (stanKlawiatury.IsKeyDown(Keys.OemPeriod)) macierzObrotu *= Matrix.CreateRotationZ((float)(-2 * gameTime.ElapsedGameTime.TotalSeconds));
            efekt.World *= macierzObrotu;

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            foreach (ModelMesh siatka in czajniczek.Meshes)
            {
                foreach (Effect efekt in siatka.Effects)
                {
                    siatka.Draw();
                }
            }

            base.Draw(gameTime);
        }
    }
}
