float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float4x4 World : WORLD;
float4 Kolor : COLOR = float4(1.0,1.0,0.0,1.0);
bool UzyjKoloruWerteksu = true;
bool PreferujPerPixel = true;
float Czas : TIME = 0;

//zrodlo swiatla
float4 Ca : COLOR = float4(0.1,0.1,0.1,1);
float4 Cd : COLOR = float4(0.5,0.5,0.5,1);
float4 Cs : COLOR = float4(1,1,1,1);
float3 PozycjaZrodlaSwiatla = float3(3,3,3);
float3 KierunekDoKamery = float3(0,0,1);

//material
float4 Wa : COLOR = float4(1,1,1,1);
float4 Wd : COLOR = float4(1,1,1,1);
float4 Ws : COLOR = float4(1,1,1,1);
float ns = 10;

struct Dane_Wejsciowe_VS
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;
	float3 Normalna : NORMAL0;
};

struct Dane_Wyjsciowe_VS
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;

	float4 Pozycja_Kopia : TEXCOORD1;
	float3 Normalna_Kopia : TEXCOORD2;
};

float4 OswietleniePhonga(float4 Pozycja,float4 Kolor,float3 N)
{
	float3 polozenieNaScenie = mul(Pozycja,World);
	float3 L = normalize(PozycjaZrodlaSwiatla - polozenieNaScenie);
	float dotLN = saturate(dot(L,N));

	float3 R = -L + 2*dotLN*N;
	float dotCR = saturate(pow(dot(R,KierunekDoKamery),ns));

	float4 _Wa = Wa;
	float4 _Wd = Wd;
	if(UzyjKoloruWerteksu) 
	{
		_Wa=Kolor;
		_Wd=Kolor;
	}

	//if(input.Pozycja.x < 0) output.Kolor = float4(0,1,0,1);	
	float4 output_Kolor = saturate(_Wa*Ca);
	output_Kolor += saturate(_Wd*Cd*dotLN);
	output_Kolor += saturate(Ws*Cs*dotCR);
	return output_Kolor;
}

Dane_Wyjsciowe_VS VS(Dane_Wejsciowe_VS input)
{
	Dane_Wyjsciowe_VS output;
	output.Pozycja = mul(input.Pozycja,WorldViewProjection);	
	
	output.Normalna_Kopia = mul(input.Normalna,World);
	if(!PreferujPerPixel) output.Kolor = OswietleniePhonga(input.Pozycja,input.Kolor,output.Normalna_Kopia);
	else
	{
		if(UzyjKoloruWerteksu) output.Kolor = input.Kolor;
		else output.Kolor = Kolor;
	}
	output.Pozycja_Kopia = input.Pozycja;	

	return output;
}

float4 PS(Dane_Wyjsciowe_VS input) : COLOR0
{	
	float amplituda = 0.2;
	float czestosc = 10;
	float faza = 10*Czas;

	if(!PreferujPerPixel) return input.Kolor;
	else return OswietleniePhonga(input.Pozycja_Kopia,input.Kolor,input.Normalna_Kopia);

		//if(input.Pozycja_Kopia.x < 0) return float4(0,1,0,1);
		//else return float4(0,1,1,1);
		//if(input.Pozycja_Kopia.x < amplituda*sin(czestosc*input.Pozycja_Kopia.y+faza)) return float4(0,1,0,1);
		//else return float4(0,1,1,1);
		//return float4(input.Normalna_Kopia.xyz,1);
}

Technique technika
{
	Pass przebieg
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}