float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float4x4 World : WORLD;
float4 Kolor : COLOR = float4(1.0,1.0,0.0,1.0);
bool UzyjKoloruWerteksu = true;
bool PreferujPerPixel = true;
float Czas : TIME = 0;

//zrodlo swiatla
float4 Ca : COLOR = float4(0.1,0.1,0.1,1);
float4 Cd : COLOR = float4(0.8,0.8,0.8,1);
float4 Cs : COLOR = float4(1,1,1,1);
float3 PozycjaZrodlaSwiatla = float3(1,1,1);
float3 KierunekDoKamery = float3(0,0,1);

//material
float4 Wa : COLOR = float4(1,1,1,1);
float4 Wd : COLOR = float4(1,1,1,1);
float4 Ws : COLOR = float4(1,1,1,1);
float ns = 10;

struct Dane_Wejsciowe_VS
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;
	float3 Normalna : NORMAL0;
};

struct Dane_Wyjsciowe_VS
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;

	float4 Pozycja_Kopia : TEXCOORD1;
	float3 Normalna_Kopia : TEXCOORD2;
};

Dane_Wyjsciowe_VS VS(Dane_Wejsciowe_VS input)
{
	Dane_Wyjsciowe_VS output;
	output.Pozycja = mul(input.Pozycja,WorldViewProjection);	
	//if(UzyjKoloruWerteksu) output.Kolor = input.Kolor;
	//else output.Kolor = Kolor;

	output.Normalna_Kopia = mul(input.Normalna,World);
	if(!PreferujPerPixel)
	{
		float3 polozenieNaScenie = mul(input.Pozycja,World);
		float3 L = normalize(PozycjaZrodlaSwiatla - polozenieNaScenie);
		float dotLN = saturate(dot(L,output.Normalna_Kopia));

		//if(input.Pozycja.x < 0) output.Kolor = float4(0,1,0,1);	
		output.Kolor = saturate(Wa*Ca);
		output.Kolor += saturate(Wd*Cd*dotLN);
	}	
	output.Pozycja_Kopia = input.Pozycja;	

	return output;
}

float4 PS(Dane_Wyjsciowe_VS input) : COLOR0
{	
	float amplituda = 0.2;
	float czestosc = 10;
	float faza = 10*Czas;

	if(!PreferujPerPixel) return input.Kolor;
	else
		//if(input.Pozycja_Kopia.x < 0) return float4(0,1,0,1);
		//else return float4(0,1,1,1);
		//if(input.Pozycja_Kopia.x < amplituda*sin(czestosc*input.Pozycja_Kopia.y+faza)) return float4(0,1,0,1);
		//else return float4(0,1,1,1);
		return float4(input.Normalna_Kopia.xyz,1);
}

Technique technika
{
	Pass przebieg
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}