using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

using DrugiProjekt;

namespace HLSL
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;

        BasicEffect efekt;
        Prostopadloscian p;       
        Texture2D tekstura;

        Prostopadloscian_Efekt p_Efekt;
        Effect mojEfekt;

        public Game1()
        {
            this.IsMouseVisible = true;
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            efekt = new BasicEffect(this.GraphicsDevice);
            efekt.World = Matrix.Identity;
            efekt.View = Matrix.CreateLookAt(
                3 * Vector3.UnitZ,
                Vector3.Zero,
                Vector3.UnitY);
            efekt.Projection = Matrix.CreatePerspective(
                2 * this.GraphicsDevice.Viewport.AspectRatio,
                2,
                1,
                100);
            efekt.VertexColorEnabled = true;
            efekt.SpecularColor = Color.Black.ToVector3();
            efekt.PreferPerPixelLighting = false;
            efekt.EnableDefaultLighting();
            
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            mojEfekt = Content.Load<Effect>("Efekt");
            mojEfekt.Parameters["WorldViewProjection"].SetValue(efekt.World * efekt.View * efekt.Projection);
            mojEfekt.Parameters["World"].SetValue(efekt.World);
            mojEfekt.Parameters["Kolor"].SetValue(Color.Yellow.ToVector4());

            tekstura = Content.Load<Texture2D>("drewno");
            efekt.Texture = tekstura;
            //efekt.TextureEnabled = true;
            
            efekt.World *= Matrix.CreateTranslation(new Vector3(-1, 0, 0));
            p = new Prostopadloscian(this, efekt, 1, 1.5f, 2, Color.White);
            this.Components.Add(p);

            efekt.World *= Matrix.CreateTranslation(new Vector3(2, 0, 0));
            p_Efekt = new Prostopadloscian_Efekt(this, mojEfekt, efekt.World, efekt.View, efekt.Projection, 1, 1.5f, 2, null);
            this.Components.Add(p_Efekt);
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            // TODO: Add your drawing code here

            base.Draw(gameTime);
        }
    }
}
