float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float4 Kolor : COLOR = float4(1.0,1.0,0.0,1.0);
bool UzyjKoloruWerteksu = true;
bool PreferujPerPixel = true;
float Czas : TIME = 0;

struct Dane_Wejsciowe_VS
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;
	//float4 Normalna : NORMAL0;
};

struct Dane_Wyjsciowe_VS
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;

	float4 Pozycja_Kopia : TEXCOORD1;
};

Dane_Wyjsciowe_VS VS(Dane_Wejsciowe_VS input)
{
	Dane_Wyjsciowe_VS output;
	output.Pozycja = mul(input.Pozycja,WorldViewProjection);	
	if(UzyjKoloruWerteksu) output.Kolor = input.Kolor;
	else output.Kolor = Kolor;

	if(!PreferujPerPixel) 
		if(input.Pozycja.x < 0) 
			output.Kolor = float4(0,1,0,1);	
	output.Pozycja_Kopia = input.Pozycja;	

	return output;
}

float4 PS(Dane_Wyjsciowe_VS input) : COLOR0
{	
	float amplituda = 0.2;
	float czestosc = 10;
	float faza = 10*Czas;

	if(!PreferujPerPixel) return input.Kolor;
	else
		//if(input.Pozycja_Kopia.x < 0) return float4(0,1,0,1);
		//else return float4(0,1,1,1);
		if(input.Pozycja_Kopia.x < amplituda*sin(czestosc*input.Pozycja_Kopia.y+faza)) return float4(0,1,0,1);
		else return float4(0,1,1,1);
}

Technique technika
{
	Pass przebieg
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}