﻿    using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace DrugiProjekt
{
    public struct VertexPositionColorNormal
    {
        public Vector3 Position;
        public Color Color;
        public Vector3 Normal;

        public VertexPositionColorNormal(Vector3 Position, Color Color, Vector3 Normal)
        {
            this.Position = Position;
            this.Color = Color;
            this.Normal = Normal;
        }

        public static readonly VertexDeclaration VertexDeclaration = new VertexDeclaration(
            new VertexElement(0,VertexElementFormat.Vector3,VertexElementUsage.Position,0),
            new VertexElement(3*sizeof(float),VertexElementFormat.Color,VertexElementUsage.Color,0),
            new VertexElement(3*sizeof(float)+sizeof(uint),VertexElementFormat.Vector3,VertexElementUsage.Normal,0)
            );
    }

    public struct VertexPositionColorNormalTexture
    {
        public Vector3 Position;
        public Color Color;
        public Vector3 Normal;
        public Vector2 TextureCoordinates;

        public VertexPositionColorNormalTexture(Vector3 Position, Color Color, Vector3 Normal, Vector2 TextureCoordinates)
        {
            this.Position = Position;
            this.Color = Color;
            this.Normal = Normal;
            this.TextureCoordinates = TextureCoordinates;
        }

        public static readonly VertexDeclaration VertexDeclaration = new VertexDeclaration(
            new VertexElement(0, VertexElementFormat.Vector3, VertexElementUsage.Position, 0),
            new VertexElement(3 * sizeof(float), VertexElementFormat.Color, VertexElementUsage.Color, 0),
            new VertexElement(3 * sizeof(float) + sizeof(uint), VertexElementFormat.Vector3, VertexElementUsage.Normal, 0),
            new VertexElement(6 * sizeof(float) + sizeof(uint), VertexElementFormat.Vector2, VertexElementUsage.TextureCoordinate, 0)
            );
    }
}
