using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace CzwartaGra_Grafika2D
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Texture2D drzewo, tlo, samochod, teksturaBum;
        Rectangle drzewoBounds, samochodBounds;
        bool czyZderzenie = false;
        bool czyOdtworzycDzwiek = true;

        int poziom = 0;
        int samochod_x = 0;
        float samochod_predkosc_x = 100;

        SpriteFont czcionkaBum;
        SoundEffect dzwiekBum;

        public Game1()
        {
            this.IsMouseVisible = true;

            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);            

            drzewo = Content.Load<Texture2D>("Drzewo");            
            tlo = Content.Load<Texture2D>("Tlo");
            samochod = Content.Load<Texture2D>("Samochod");

            graphics.PreferredBackBufferWidth = tlo.Width;
            graphics.PreferredBackBufferHeight = tlo.Height;
            graphics.ApplyChanges();

            poziom = tlo.Height / 2;
            samochod_x = tlo.Width;

            drzewoBounds = new Rectangle(100, poziom, 3 * drzewo.Width, 5 * drzewo.Height);

            czcionkaBum = Content.Load<SpriteFont>("CzcionkaBum");
            //http://www.mediacollege.com/downloads/sound-effects/explosion/
            dzwiekBum = Content.Load<SoundEffect>("explosion-03");
            teksturaBum = Content.Load<Texture2D>("Bum");
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here
            samochod_x -= (int)Math.Round(samochod_predkosc_x * gameTime.ElapsedGameTime.TotalSeconds);
            samochodBounds = new Rectangle(samochod_x, poziom + 65, 3 * samochod.Width, 3 * samochod.Height);

            //detekcja kolizji
            czyZderzenie = drzewoBounds.Intersects(samochodBounds);

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.White);

            spriteBatch.Begin();
            spriteBatch.Draw(tlo, new Rectangle(0, 0, Window.ClientBounds.Width, Window.ClientBounds.Height), Color.White);
            spriteBatch.Draw(drzewo, drzewoBounds, Color.White);
            
            if (!czyZderzenie)
                spriteBatch.Draw(samochod, samochodBounds, Color.White);
            else
            {
                spriteBatch.Draw(teksturaBum, samochodBounds, Color.White);
                samochod_predkosc_x = 0;
                spriteBatch.DrawString(czcionkaBum, "Bum!!!", new Vector2(2 * tlo.Width / 5, tlo.Height / 2), Color.Yellow);                
                if(czyOdtworzycDzwiek) dzwiekBum.Play();                
                czyOdtworzycDzwiek = false;
            }
            spriteBatch.End();

            //W domu:
            //jak narysowac obracaja sie tekstura

            base.Draw(gameTime);
        }
    }
}
