﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace ITA106
{
    //Wlasne struktury opisujace werteks
    public struct VertexPositionColorNormal : IVertexType
    {
        public Vector3 Position;
        public Color Color;
        public Vector3 Normal;

        //public static int SizeInBytes = 6 * sizeof(float) + sizeof(uint);

        public readonly static VertexDeclaration VertexDeclaration = new VertexDeclaration(
            new VertexElement( 0, VertexElementFormat.Vector3, VertexElementUsage.Position, 0 ),
            new VertexElement( sizeof(float) * 3, VertexElementFormat.Color, VertexElementUsage.Color, 0 ),
            new VertexElement( sizeof(float) * 3 + sizeof(uint), VertexElementFormat.Vector3, VertexElementUsage.Normal, 0) );

        VertexDeclaration IVertexType.VertexDeclaration { get { return VertexDeclaration; } }

        public VertexPositionColorNormal(Vector3 position, Color color, Vector3 normal)
        {
            this.Position = position;
            this.Color = color;
            this.Normal = normal;
        }
    }

    public struct VertexPositionColorNormalTexture : IVertexType
    {
        public Vector3 Position;
        public Color Color;
        public Vector3 Normal;
        public Vector2 TextureCoordinate;

        //public static int SizeInBytes = 8 * sizeof(float) + sizeof(uint);

        public static readonly VertexDeclaration VertexDeclaration = new VertexDeclaration(
            new VertexElement( 0, VertexElementFormat.Vector3, VertexElementUsage.Position, 0 ),
            new VertexElement( sizeof(float) * 3, VertexElementFormat.Color, VertexElementUsage.Color, 0 ),
            new VertexElement( sizeof(float) * 4, VertexElementFormat.Vector3, VertexElementUsage.Normal, 0 ),
            new VertexElement( sizeof(float) * 6 + sizeof(uint), VertexElementFormat.Vector2, VertexElementUsage.TextureCoordinate, 0 ) );

        VertexDeclaration IVertexType.VertexDeclaration { get { return VertexDeclaration; } }

        public VertexPositionColorNormalTexture(Vector3 position, Color color, Vector3 normal, Vector2 textureCoordinate)
        {
            this.Position = position;
            this.Color = color;
            this.Normal = normal;
            this.TextureCoordinate = textureCoordinate;
        }
    }
}
