using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

using ITA106;

namespace RzutowanieCieni
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        BasicEffect efekt;

        Prostopadloscian szescian, podloze;
        Prostopadloscian cienSzescianu;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            this.graphics.GraphicsProfile = GraphicsProfile.Reach;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            //efekt                        
            efekt = new BasicEffect(graphics.GraphicsDevice);
            efekt.VertexColorEnabled = true;
            efekt.Projection = Matrix.CreatePerspective(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 1.0f, 100.0f);
            efekt.View = Matrix.CreateLookAt(new Vector3(0, 0, 2.5f), new Vector3(0, 0, 0), new Vector3(0, 1, 0));

            //oswietlenie domyslne
            efekt.EnableDefaultLighting();
            efekt.SpecularColor = Color.White.ToVector3();
            efekt.SpecularPower = 16;
            efekt.DiffuseColor = Color.White.ToVector3();
            efekt.AmbientLightColor = Color.Gray.ToVector3();
            efekt.EmissiveColor = Color.Black.ToVector3();

            //zrodla swiatla
            efekt.DirectionalLight0.DiffuseColor = Color.White.ToVector3();
            efekt.DirectionalLight0.SpecularColor = Color.White.ToVector3();
            efekt.DirectionalLight1.DiffuseColor = Color.Black.ToVector3();
            efekt.DirectionalLight1.SpecularColor = Color.Black.ToVector3();
            efekt.DirectionalLight2.DiffuseColor = Color.Black.ToVector3();
            efekt.DirectionalLight2.SpecularColor = Color.Black.ToVector3();
            
            //szescian
            szescian = new Prostopadloscian(this, efekt, 1, 1, 1, Color.Chocolate);
            this.Components.Add(szescian);

            //podloze
            podloze = new Prostopadloscian(this, efekt, 7, 0.1f, 5, Color.Green);
            podloze.World *= Matrix.CreateTranslation(0, -1.75f, -2);
            this.Components.Add(podloze);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // TODO: use this.Content to load your game content here
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            //klawiatura
            if (Keyboard.GetState().IsKeyDown(Keys.Escape)) this.Exit();
            if (Keyboard.GetState().IsKeyDown(Keys.Space)) graphics.ToggleFullScreen();            

            efekt.World*=
                Matrix.CreateRotationX(gameTime.ElapsedGameTime.Milliseconds / 1000.0f) *
                Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);

            szescian.World = efekt.World;
            
            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            base.Draw(gameTime);
        }

    }
}
