using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace PierwszaGra1
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        BasicEffect efekt;
        GraphicsDevice gd;

        const float d = 0.5f;
        const float z = 0f;
        const float y = -d;
        VertexPositionColor[] werteksy = new VertexPositionColor[3]
        {            
            new VertexPositionColor(new Vector3(d,y,z),Color.Cyan),
            new VertexPositionColor(new Vector3(-d,y,z),Color.Magenta),
            new VertexPositionColor(new Vector3(0,d,z),Color.Yellow)
        };

        VertexBuffer buforWerteksow;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            graphics.PreferredBackBufferWidth = 1280;
            graphics.PreferredBackBufferHeight = 1024;
            graphics.IsFullScreen = true;

            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            this.IsMouseVisible = true;

            gd = graphics.GraphicsDevice;
            gd.RasterizerState = new RasterizerState() { CullMode = CullMode.None, FillMode = FillMode.Solid };            

            buforWerteksow = new VertexBuffer(gd, VertexPositionColor.VertexDeclaration, 3, BufferUsage.WriteOnly);
            buforWerteksow.SetData<VertexPositionColor>(werteksy);

            efekt = new BasicEffect(gd);
            efekt.VertexColorEnabled = true;

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            Matrix macierzPrzeksztalcenia = Matrix.CreateRotationY(-0.01f);
            efekt.World *= macierzPrzeksztalcenia;
            efekt.View = Matrix.CreateLookAt(new Vector3(0,0,2.5f),Vector3.Zero,Vector3.Up);
            efekt.Projection = Matrix.CreateOrthographic(2f*gd.Viewport.AspectRatio, 2f, 0f, 100f);

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            //GraphicsDevice.Clear(Color.CornflowerBlue);
            gd.Clear(Color.Black);


            foreach (EffectPass p in efekt.CurrentTechnique.Passes)
            {
                p.Apply();

                gd.SetVertexBuffer(buforWerteksow);

                //gd.DrawUserPrimitives(PrimitiveType.TriangleList, werteksy, 0, 1);
                gd.DrawPrimitives(PrimitiveType.TriangleList, 0, 1);                
            }

            // TODO: Add your drawing code here

            base.Draw(gameTime);
        }
    }
}
