using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace ProjektZKomponentem
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Effect efekt;

        Prostopadloscian p1, p2, p3;
        Vector3 polozenie1 = -Vector3.UnitY, polozenie2 = new Vector3(0,0,0.7f), polozenie3 = new Vector3(-1, -0.5f, -0.5f), 
            polocenie_czajnik = new Vector3(0.7f, 0.5f, 0.75f);

        Model czajnik;
        Matrix czajnikWorld;
        Effect czajnikEfekt;

        Matrix View, Projection;
        Matrix szescianWorld;

        Vector3 pozycjaKamery = new Vector3(0, 0, 2.5f);
        Vector3 pozycjaZrodlaSwiatla = 1.5f * Vector3.One;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            this.IsMouseVisible = true;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            Projection = Matrix.CreatePerspective(
                2 * graphics.GraphicsDevice.Viewport.AspectRatio,
                2,
                1,
                100);
            View = Matrix.CreateLookAt(
                pozycjaKamery,
                new Vector3(0, 0, 0),
                new Vector3(0, 1, 0));                        

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            efekt = Content.Load<Effect>("Efekt");
            efekt.Parameters["World"].SetValue(Matrix.Identity);
            
            efekt.Parameters["PozycjaZrodlaSwiatla"].SetValue(pozycjaZrodlaSwiatla);
            efekt.Parameters["ZrodloSwiatla_ViewProjection"].SetValue(
                Matrix.CreateLookAt(pozycjaZrodlaSwiatla,new Vector3(1,-0.5f,-0.25f), Vector3.Up)*
                Matrix.CreatePerspective(2*graphics.GraphicsDevice.Viewport.AspectRatio,2,1,10));
            efekt.Parameters["MaksymalnaOdlegloscZrodlaSwiatla"].SetValue(5);

            efekt.Parameters["PozycjaKamery"].SetValue(pozycjaKamery);
            efekt.Parameters["Kamera_ViewProjection"].SetValue(View * Projection);

            efekt.Parameters["MapowanieCieni"].SetValue(true);

            p1 = new Prostopadloscian(this, efekt, 4, 0.1f, 2.5f, Color.Green);
            p1.Efekt.Parameters["Kolor"].SetValue(Color.Green.ToVector4());
            p1.Efekt.Parameters["World"].SetValue(Matrix.CreateTranslation(polozenie1));
            float dlg2 = 0.5f;
            p2 = new Prostopadloscian(this, efekt, dlg2, dlg2, dlg2, Color.CornflowerBlue);
            p2.Efekt.Parameters["Kolor"].SetValue(Color.CornflowerBlue.ToVector4());
            szescianWorld = Matrix.CreateTranslation(polozenie2);
            p2.Efekt.Parameters["World"].SetValue(szescianWorld);
            p3 = new Prostopadloscian(this, efekt, 1, 1, 1, Color.Green);
            p3.Efekt.Parameters["Kolor"].SetValue(Color.Green.ToVector4());
            p3.Efekt.Parameters["World"].SetValue(Matrix.CreateTranslation(polozenie3));
            //this.Components.Add(p1);
            //this.Components.Add(p2);
            //this.Components.Add(p3);

            czajnikWorld = Matrix.CreateScale(0.5f) * Matrix.CreateTranslation(polocenie_czajnik);

            czajnik = Content.Load<Model>("teapot");
            czajnikEfekt = efekt.Clone();
            czajnikEfekt.Parameters["Kolor"].SetValue(Color.White.ToVector4());
            czajnikEfekt.Parameters["World"].SetValue(czajnikWorld);            
            foreach (ModelMesh siatka in czajnik.Meshes)
            {
                foreach (ModelMeshPart czescSiatki in siatka.MeshParts)
                {
                    czescSiatki.Effect = czajnikEfekt;
                }
            }            
        }

        KeyboardState poprzedniStanKlawiatury = Keyboard.GetState();

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        float poprawkaGlebi = 0.01f;

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            bool automatyczneObracanie = true;

            
            KeyboardState stanKlawiatury = Keyboard.GetState();
            if (stanKlawiatury.GetPressedKeys().Count() > 0)
            {
                //kontrola korekcji cienia
                if (stanKlawiatury.IsKeyDown(Keys.Z) && poprzedniStanKlawiatury.IsKeyUp(Keys.Z)) poprawkaGlebi *= 0.99f;
                if (stanKlawiatury.IsKeyDown(Keys.X) && poprzedniStanKlawiatury.IsKeyUp(Keys.X)) poprawkaGlebi *= 1.01f;
                this.Window.Title = "Poprawka gbi: " + poprawkaGlebi.ToString();
                p1.Efekt.Parameters["PoprawkaGlebi"].SetValue(poprawkaGlebi);
                p2.Efekt.Parameters["PoprawkaGlebi"].SetValue(poprawkaGlebi);
                p3.Efekt.Parameters["PoprawkaGlebi"].SetValue(poprawkaGlebi);
                czajnikEfekt.Parameters["PoprawkaGlebi"].SetValue(poprawkaGlebi);

                //sterowanie kamera
                float szybkoscObracaniaKamery = 0.02f;
                View *= Matrix.CreateTranslation(pozycjaKamery);
                if (stanKlawiatury.IsKeyDown(Keys.Left) && poprzedniStanKlawiatury.IsKeyUp(Keys.Left)) View *= Matrix.CreateRotationY(-szybkoscObracaniaKamery);
                if (stanKlawiatury.IsKeyDown(Keys.Right) && poprzedniStanKlawiatury.IsKeyUp(Keys.Right)) View *= Matrix.CreateRotationY(szybkoscObracaniaKamery);
                if (stanKlawiatury.IsKeyDown(Keys.Up) && poprzedniStanKlawiatury.IsKeyUp(Keys.Up)) View *= Matrix.CreateRotationX(szybkoscObracaniaKamery);
                if (stanKlawiatury.IsKeyDown(Keys.Down) && poprzedniStanKlawiatury.IsKeyUp(Keys.Down)) View *= Matrix.CreateRotationX(-szybkoscObracaniaKamery);
                View *= Matrix.CreateTranslation(-pozycjaKamery);
                p1.Efekt.Parameters["Kamera_ViewProjection"].SetValue(View * Projection);
                p2.Efekt.Parameters["Kamera_ViewProjection"].SetValue(View * Projection);
                p3.Efekt.Parameters["Kamera_ViewProjection"].SetValue(View * Projection);
                czajnikEfekt.Parameters["Kamera_ViewProjection"].SetValue(View * Projection);

                //sterowanie pozycja zrodla swiatla
                float szybkoscZmianyPolozeniaZrodlaSwiatla = 0.02f;
                if (stanKlawiatury.IsKeyDown(Keys.A) && poprzedniStanKlawiatury.IsKeyUp(Keys.A)) pozycjaZrodlaSwiatla -= Vector3.UnitX * szybkoscZmianyPolozeniaZrodlaSwiatla;
                if (stanKlawiatury.IsKeyDown(Keys.D) && poprzedniStanKlawiatury.IsKeyUp(Keys.D)) pozycjaZrodlaSwiatla += Vector3.UnitX * szybkoscZmianyPolozeniaZrodlaSwiatla;
                if (stanKlawiatury.IsKeyDown(Keys.W) && poprzedniStanKlawiatury.IsKeyUp(Keys.W)) pozycjaZrodlaSwiatla += Vector3.UnitY * szybkoscZmianyPolozeniaZrodlaSwiatla;
                if (stanKlawiatury.IsKeyDown(Keys.S) && poprzedniStanKlawiatury.IsKeyUp(Keys.S)) pozycjaZrodlaSwiatla -= Vector3.UnitY * szybkoscZmianyPolozeniaZrodlaSwiatla;
                this.Window.Title += ", rdo wiata: " + pozycjaZrodlaSwiatla.ToString();
                p1.Efekt.Parameters["PozycjaZrodlaSwiatla"].SetValue(pozycjaZrodlaSwiatla);
                p1.Efekt.Parameters["ZrodloSwiatla_ViewProjection"].SetValue(
                    Matrix.CreateLookAt(pozycjaZrodlaSwiatla, new Vector3(1, -0.5f, -0.25f), Vector3.Up) *
                    Matrix.CreatePerspective(2 * graphics.GraphicsDevice.Viewport.AspectRatio, 2, 1, 10));
                p2.Efekt.Parameters["PozycjaZrodlaSwiatla"].SetValue(pozycjaZrodlaSwiatla);
                p2.Efekt.Parameters["ZrodloSwiatla_ViewProjection"].SetValue(
                    Matrix.CreateLookAt(pozycjaZrodlaSwiatla, new Vector3(1, -0.5f, -0.25f), Vector3.Up) *
                    Matrix.CreatePerspective(2 * graphics.GraphicsDevice.Viewport.AspectRatio, 2, 1, 10));
                p3.Efekt.Parameters["PozycjaZrodlaSwiatla"].SetValue(pozycjaZrodlaSwiatla);
                p3.Efekt.Parameters["ZrodloSwiatla_ViewProjection"].SetValue(
                    Matrix.CreateLookAt(pozycjaZrodlaSwiatla, new Vector3(1, -0.5f, -0.25f), Vector3.Up) *
                    Matrix.CreatePerspective(2 * graphics.GraphicsDevice.Viewport.AspectRatio, 2, 1, 10));
                czajnikEfekt.Parameters["PozycjaZrodlaSwiatla"].SetValue(pozycjaZrodlaSwiatla);
                czajnikEfekt.Parameters["ZrodloSwiatla_ViewProjection"].SetValue(
                    Matrix.CreateLookAt(pozycjaZrodlaSwiatla, new Vector3(1, -0.5f, -0.25f), Vector3.Up) *
                    Matrix.CreatePerspective(2 * graphics.GraphicsDevice.Viewport.AspectRatio, 2, 1, 10));
            }

            if (automatyczneObracanie)
            {
                Matrix obrot =
                    Matrix.CreateRotationX(gameTime.ElapsedGameTime.Milliseconds / 1500.0f) *
                    Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 2000.0f);
                szescianWorld *= Matrix.CreateTranslation(-polozenie2);
                szescianWorld *= obrot;
                szescianWorld *= Matrix.CreateTranslation(polozenie2);
                p2.Efekt.Parameters["World"].SetValue(szescianWorld);

                czajnikWorld *= Matrix.CreateTranslation(-polocenie_czajnik);
                czajnikWorld *= Matrix.CreateRotationY(0.01f) * Matrix.CreateRotationZ(0.005f);
                czajnikWorld *= Matrix.CreateTranslation(polocenie_czajnik);
                czajnikEfekt.Parameters["World"].SetValue(czajnikWorld);
            }

            p1.Update(gameTime);
            p2.Update(gameTime);
            p3.Update(gameTime);

            base.Update(gameTime);
        }


        private void Rysuj(GameTime gameTime)
        {
            p1.Draw(gameTime);
            p2.Draw(gameTime);
            p3.Draw(gameTime);
            
            foreach (ModelMesh siatka in czajnik.Meshes)
            {
                siatka.Draw();
            }
        }

        int szerokoscMapyGlebi = 1024;
        int wysokoscMapyGlebi = 1024;
        RenderTarget2D mapaGlebi;

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice gd = this.GraphicsDevice;

            if(mapaGlebi==null) mapaGlebi=new RenderTarget2D(gd,szerokoscMapyGlebi,wysokoscMapyGlebi);

            const string tech_MG = "Technika_MapaGlebi";
            const string tech_RYS = "Technika_Rysowanie";
            
            //budowanie mapy glebi
            string biezacaTechnika = tech_MG;
            gd.Clear(Color.White);            
            p1.Efekt.CurrentTechnique = p1.Efekt.Techniques[biezacaTechnika];
            p2.Efekt.CurrentTechnique = p2.Efekt.Techniques[biezacaTechnika];
            p3.Efekt.CurrentTechnique = p3.Efekt.Techniques[biezacaTechnika];
            czajnikEfekt.CurrentTechnique = czajnikEfekt.Techniques[biezacaTechnika];
            gd.SetRenderTarget(mapaGlebi);
            Rysuj(gameTime);

            //renderowanie sceny z oswietleniem            
            gd.SetRenderTarget(null);
            p1.Efekt.Parameters["MapaGlebi"].SetValue(mapaGlebi);
            p2.Efekt.Parameters["MapaGlebi"].SetValue(mapaGlebi);
            p3.Efekt.Parameters["MapaGlebi"].SetValue(mapaGlebi);
            czajnikEfekt.Parameters["MapaGlebi"].SetValue(mapaGlebi);
            biezacaTechnika = tech_RYS;
            p1.Efekt.CurrentTechnique = p1.Efekt.Techniques[biezacaTechnika];
            p2.Efekt.CurrentTechnique = p2.Efekt.Techniques[biezacaTechnika];
            p3.Efekt.CurrentTechnique = p3.Efekt.Techniques[biezacaTechnika];
            czajnikEfekt.CurrentTechnique = czajnikEfekt.Techniques[biezacaTechnika];
            gd.Clear(Color.Black);
            Rysuj(gameTime);

            spriteBatch.Begin(SpriteSortMode.Texture,gd.BlendState,gd.SamplerStates[0],gd.DepthStencilState,gd.RasterizerState);
            spriteBatch.Draw(mapaGlebi,new Rectangle(0,0,128,128),Color.White);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
