float4x4 World : WORLD;

//--------------------------------

//parametry rda wiata
float4x4 ZrodloSwiatla_ViewProjection;
float3 PozycjaZrodlaSwiatla : LIGHTPOSITION;

//Maksymalna wartosc glebi dla renderingu z perspektywy swiatla
float MaksymalnaOdlegloscZrodlaSwiatla;

struct VS_MapaGlebi_Input
{
	float4 Pozycja : POSITION;
};

struct VS_MapaGlebi_Output
{
	float4 Pozycja : POSITION;
	float Glebokosc : TEXCOORD1;
};

VS_MapaGlebi_Output VS_MapaGlebi(VS_MapaGlebi_Input input)
{
	VS_MapaGlebi_Output output;
	float4x4 wvp = mul(World,ZrodloSwiatla_ViewProjection);
	output.Pozycja=mul(input.Pozycja, wvp);
	//zapisujemy wartosc glebi ([0-1])
	output.Glebokosc=output.Pozycja.z/MaksymalnaOdlegloscZrodlaSwiatla;
	return output;
}

float4 PS_MapaGlebi(VS_MapaGlebi_Output input) : COLOR0
{
	return float4(1,1,1,0)*input.Glebokosc+float4(0,0,0,1);
}

technique Technika_MapaGlebi
{
	pass Przebieg
	{
		CullMode = NONE;
		VertexShader = compile vs_2_0 VS_MapaGlebi();
		PixelShader = compile ps_2_0 PS_MapaGlebi();
	}
}

//-----------------------------------------------------------------

//parametry kamery
float4x4 Kamera_ViewProjection : VIEWPROJECTION;
float3 PozycjaKamery : CAMERAPOSITION;

float4 Kolor;

struct VS_Rysowanie_Input
{
	float4 Pozycja: POSITION0;
	float3 Normalna : NORMAL0;
};

struct VS_Rysowanie_Output
{
	float4 Pozycja : POSITION0;
	float4 Kolor : COLOR0;
	float4 PozycjaScena : TEXCOORD1;
	float3 NormalnaScena : TEXCOORD2;
};

VS_Rysowanie_Output VS_Rysowanie(VS_Rysowanie_Input input)
{
	VS_Rysowanie_Output output;
	output.PozycjaScena=mul(input.Pozycja,World);
	output.Pozycja=mul(output.PozycjaScena,Kamera_ViewProjection);
	output.NormalnaScena=mul(input.Normalna,World);
	output.Kolor=Kolor;
	return output;
}

float4 PS_Rysowanie(VS_Rysowanie_Output input) : COLOR0
{
	//swiatlo otoczenia
	float4 output_Kolor = input.Kolor*0.4; 

	//swiatlo rozproszone
	float3 L = normalize(PozycjaZrodlaSwiatla - input.PozycjaScena.xyz);
	float dotNL = saturate(dot(input.NormalnaScena,L));
	output_Kolor += 1*input.Kolor*dotNL; 

	//rozblysk
	float Ns = 10;
	float3 V = normalize(PozycjaKamery - input.PozycjaScena.xyz);
	float3 Ln = dotNL * input.NormalnaScena;
	float3 R = 2*Ln - L;
	float dotRV = pow(saturate(dot(R,V)),Ns);
	output_Kolor += 0*float4(1,1,1,1)*dotRV;

	return output_Kolor;
}

technique Technika_Rysowanie
{
	pass Przebieg
	{
		VertexShader = compile vs_2_0 VS_Rysowanie();
		PixelShader = compile ps_2_0 PS_Rysowanie();
	}
}
