using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace ProjektZKomponentem
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        BasicEffect efekt;

        Prostopadloscian p1, p2, p2_cien;
        Vector3 polozenie1 = -Vector3.UnitY, polozenie2 = Vector3.UnitZ;

        Model czajnik;
        Matrix czajnikWorld;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            this.IsMouseVisible = true;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            efekt = new BasicEffect(graphics.GraphicsDevice);
            efekt.VertexColorEnabled = true;
            efekt.Projection = Matrix.CreatePerspective(
                2 * graphics.GraphicsDevice.Viewport.AspectRatio,
                2,
                1,
                100);
            efekt.View = Matrix.CreateLookAt(
                new Vector3(0, 0, 2.5f),
                new Vector3(0, 0, 0),
                new Vector3(0, 1, 0));

            efekt.EnableDefaultLighting();

            //efekt.Texture = Content.Load<Texture2D>("lena");
            //efekt.TextureEnabled = true;

            p1 = new Prostopadloscian(this, efekt, 4, 0.1f, 2.5f, Color.Green);
            p1.World *= Matrix.CreateTranslation(polozenie1);
            float dlg2 = 0.5f;
            p2 = new Prostopadloscian(this, efekt, dlg2, dlg2, dlg2, Color.CornflowerBlue);
            p2.World *= Matrix.CreateTranslation(polozenie2);
            p2_cien = new Prostopadloscian(this, efekt, dlg2, dlg2, dlg2, Color.DarkGreen);
            p2_cien.World *= Matrix.CreateTranslation(polozenie2);
            //p.AutomatycznyRuch = true;
            this.Components.Add(p1);
            this.Components.Add(p2);
            this.Components.Add(p2_cien);

            czajnikWorld = efekt.World * Matrix.CreateScale(0.5f) * Matrix.CreateTranslation(2, 0, 0);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            czajnik = Content.Load<Model>("teapot");
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            bool automatyczneObracanie = true;

            if (automatyczneObracanie)
            {
                Matrix obrot =
                    Matrix.CreateRotationX(gameTime.ElapsedGameTime.Milliseconds / 1500.0f) *
                    Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 2000.0f);
                //p1.World *= Matrix.CreateTranslation(-polozenie1);
                p2.World *= Matrix.CreateTranslation(-polozenie2);
                //p1.World *= obrot;
                p2.World *= obrot;
                //p1.World *= Matrix.CreateTranslation(polozenie1);
                p2.World *= Matrix.CreateTranslation(polozenie2);
                p2_cien.World = p2.World * Matrix.CreateShadow(new Vector3(1, 1, 1), new Plane(Vector3.UnitY, 0.9499f));

                czajnikWorld *= Matrix.CreateTranslation(-2, 0, 0);
                czajnikWorld *= Matrix.CreateRotationY(0.01f) * Matrix.CreateRotationZ(0.005f);
                czajnikWorld *= Matrix.CreateTranslation(2, 0, 0);
            }            

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            czajnik.Draw(czajnikWorld, efekt.View, efekt.Projection);

            base.Draw(gameTime);
        }
    }
}
