using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;


namespace ProjektZKomponentem
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class Prostopadloscian : Microsoft.Xna.Framework.DrawableGameComponent
    {
        GraphicsDevice gd;
        BasicEffect efekt;
        VertexBuffer buforWerteksw;

        //public bool AutomatycznyRuch = false;
        public Matrix World
        {
            get
            {
                return efekt.World;
            }
            set
            {
                efekt.World = value;
            }
        }


        public Prostopadloscian(Game game,BasicEffect efekt,float dx,float dy,float dz,Color? kolor)
            : base(game)
        {
            dx /= 2;
            dy /= 2;
            dz /= 2;

            gd = game.GraphicsDevice;
            this.efekt = (BasicEffect)efekt.Clone();

            Vector3[] punkty = new Vector3[8]
            {
                new Vector3(-dx,-dy,dz),
                new Vector3(dx,-dy,dz),
                new Vector3(dx,dy,dz),
                new Vector3(-dx,dy,dz),
                new Vector3(-dx,-dy,-dz),
                new Vector3(dx,-dy,-dz),
                new Vector3(dx,dy,-dz),
                new Vector3(-dx,dy,-dz)
            };

            Color kolor1 = (kolor == null) ? Color.Cyan : kolor.Value;
            Color kolor2 = (kolor == null) ? Color.Magenta : kolor.Value;
            Color kolor3 = (kolor == null) ? Color.Yellow : kolor.Value;

            VertexPositionColor[] werteksy = new VertexPositionColor[6 * 2 * 3]
            {
                //przednia ciana
                new VertexPositionColor(punkty[3],kolor1),
                new VertexPositionColor(punkty[2],kolor1),
                new VertexPositionColor(punkty[0],kolor1),
                new VertexPositionColor(punkty[0],kolor1),
                new VertexPositionColor(punkty[2],kolor1),
                new VertexPositionColor(punkty[1],kolor1),

                //tylnia ciana
                new VertexPositionColor(punkty[7],kolor1),
                new VertexPositionColor(punkty[4],kolor1),
                new VertexPositionColor(punkty[6],kolor1),
                new VertexPositionColor(punkty[6],kolor1),
                new VertexPositionColor(punkty[4],kolor1),
                new VertexPositionColor(punkty[5],kolor1),

                //grna ciana
                new VertexPositionColor(punkty[3],kolor2),
                new VertexPositionColor(punkty[7],kolor2),
                new VertexPositionColor(punkty[2],kolor2),
                new VertexPositionColor(punkty[2],kolor2),
                new VertexPositionColor(punkty[7],kolor2),
                new VertexPositionColor(punkty[6],kolor2),

                //dolna ciana
                new VertexPositionColor(punkty[0],kolor2),
                new VertexPositionColor(punkty[1],kolor2),
                new VertexPositionColor(punkty[4],kolor2),
                new VertexPositionColor(punkty[4],kolor2),
                new VertexPositionColor(punkty[1],kolor2),
                new VertexPositionColor(punkty[5],kolor2),

                //lewa ciana
                new VertexPositionColor(punkty[3],kolor3),
                new VertexPositionColor(punkty[0],kolor3),
                new VertexPositionColor(punkty[7],kolor3),
                new VertexPositionColor(punkty[7],kolor3),
                new VertexPositionColor(punkty[0],kolor3),
                new VertexPositionColor(punkty[4],kolor3),

                //prawa ciana
                new VertexPositionColor(punkty[1],kolor3),
                new VertexPositionColor(punkty[2],kolor3),
                new VertexPositionColor(punkty[5],kolor3),
                new VertexPositionColor(punkty[5],kolor3),
                new VertexPositionColor(punkty[2],kolor3),
                new VertexPositionColor(punkty[6],kolor3)
            };

            buforWerteksw = new VertexBuffer(
                gd,
                VertexPositionColor.VertexDeclaration,
                werteksy.Count(),
                BufferUsage.WriteOnly);
            buforWerteksw.SetData(werteksy);
        }

        /// <summary>
        /// Allows the game component to perform any initialization it needs to before starting
        /// to run.  This is where it can query for any required services and load content.
        /// </summary>
        public override void Initialize()
        {
            // TODO: Add your initialization code here

            base.Initialize();
        }

        /// <summary>
        /// Allows the game component to update itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        public override void Update(GameTime gameTime)
        {
            /*
            if (AutomatycznyRuch)
            {
                efekt.World *=
                    Matrix.CreateRotationX(gameTime.ElapsedGameTime.Milliseconds / 2000.0f) *
                    Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 2000.0f);
                    //Matrix.CreateRotationZ(gameTime.ElapsedGameTime.Milliseconds / 2000.0f);
            }
            */

            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            gd.SetVertexBuffer(buforWerteksw);
            foreach (EffectPass p in efekt.CurrentTechnique.Passes)
            {
                p.Apply();
                gd.DrawPrimitives(PrimitiveType.TriangleList, 0, 6 * 2);
            }
            
            base.Draw(gameTime);
        }
    }
}
